/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.impl.env.ESBReceiverImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.env.ESBSenderImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;

@Scope("COMPOSITE")
@Service(value=BPELComponent.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class BPELComponentImpl extends ComponentImpl<ComponentType> implements BPELComponent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELComponentImpl.class.getName());

	private Core core = null;

	// used only by frascati
	public BPELComponentImpl() throws ESBException {
		super();
	}

	public BPELComponentImpl(QName name, ComponentType model, List<Class<? extends EndpointBehaviour>> behaviourClass,
			SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}

	public Core getCore() throws ESBException {
		if(this.core == null) {
			this.createCore();
		}
		return this.core;
	}


	@SuppressWarnings("unused")
	private void createCore() throws ESBException {
		try {

			log.finest("Core Intialization...");


			// get properties
			ConfigurationEngine conf = new ConfigurationEngineImpl();
			conf.setAutoFlushMessageFrequency(5000);
			conf.setAutoTrashProcessFreqeuency(5000);

			// Create the core
			this.core = BPELFactoryImpl.getInstance().newBPELEngine(conf, 10, ESBReceiverImpl.class, 10, ESBSenderImpl.class, null);
			SCAHelper.getSCAHelper().addComponent(this.core.getComponent(), this.getComponent(), null);

			//Retrieve configuration
			NodeBehaviour nodeBehaviour = this.getNode().findBehaviour(NodeBehaviour.class);
			Configuration confNode = nodeBehaviour.getConfiguration();

			//add specific behaviour to component
			List<String> behaviours = findBPELComponentBehaviours(confNode.getProperties());
			if(behaviours.size() > 0){
				for(String beh : behaviours){
					try{
						BPELComponentImpl.log.info("behaviour : "+beh);
						Class<?> c = Class.forName(beh);
						BPELComponentImpl.log.info("behaviour.class : "+c);

						this.addBehaviourClass((Class<? extends EndpointBehaviour>) c);
					}catch (ClassNotFoundException e) {
						BPELComponentImpl.log.warning("Class not found for : "+beh+" ("+e.getMessage()+").");
					}
				}

			}
			//add specific service if needed
			List<String> services = findCoreService(confNode.getProperties());
			if(services.size() > 0){
				for(String service : services){
					try{
						core.getEngine().getServiceManager().addService((Class<? extends com.ebmwebsourcing.easyviper.core.api.engine.thread.service.Service>) Class.forName(service));

					}catch (ClassNotFoundException e) {
						BPELComponentImpl.log.warning("Class not found for : "+service+" ("+e.getMessage()+").");
					}
				}
			}

			// add extended activity if needed			
			List<URL> extendedBPELactivitiesURL = findBPELExtendedActivities(confNode.getProperties());

			if(extendedBPELactivitiesURL.size()>0){
				ExtendedActivityService service = core.getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class);

				for(URL extendedActivityURL : extendedBPELactivitiesURL){
					service.loadExtendedActivitiesConfigure(extendedActivityURL);	
				}
			}


			// add external information
			core.getExternalEnvironment().setHost(nodeBehaviour.getHost());

			SoapServer soapServer = (SoapServer) nodeBehaviour.getExternalServer("soap-server");
			if(soapServer != null) {
				core.getExternalEnvironment().setPort(String.valueOf(soapServer.getPort()));
			}
		} catch (BPELException e) {
			log.severe("ERROR e : " + e.getMessage());
			e.printStackTrace();
			throw new ESBException(e);
		} catch (Exception e) {
			log.severe("ERROR e : " + e.getMessage());
			e.printStackTrace();
			throw new ESBException(e);
		}
	}

	private List<String> findBPELComponentBehaviours(
			Map<String, String> properties) {
		List<String> res = new ArrayList<String>();

		for(String prop : properties.keySet()){
			if(prop.startsWith(BPELComponent.BPEL_BEHAVIOUR_PREFIX)){
				res.add(properties.get(prop));
			}
		}

		return res;
	}

	private List<String> findCoreService(Map<String, String> properties){
		List<String> res = new ArrayList<String>();

		for(String prop : properties.keySet()){
			if(prop.startsWith(BPELComponent.EXTENDED_CORE_SERVICE_PREFIX)){
				res.add(properties.get(prop));
			}
		}

		return res;
	}

	private List<URL> findBPELExtendedActivities(Map<String, String> properties) {
		List<URL> res = new ArrayList<URL>();

		for(String prop : properties.keySet()){
			if(prop.startsWith(BPELComponent.EXTENDED_BPEL_ACTIVITY_PREFIX)){
				URL url = Thread.currentThread().getContextClassLoader().getResource(properties.get(prop));
				if(url != null){
					res.add(url);
				}else{
					this.log.warning("Failed to retrieve extended activity configuration file for "+prop+".");
				}
			}
		}

		return res;
	}

	@Override
	public Object getContext() {
	 
	    try {
            return getCore();
        } catch (ESBException e) {
           log.warning("Context not retrieved for the BPEL component. (core)");
           return null;
        }
	}
	
}
