/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;

public class ESBImportWsdlTest {
    private Logger log = Logger.getLogger(ESBImportWsdlTest.class.getName());
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        try {
            node.start();
        }
        catch (TransportException e) {
            throw new ESBException((Throwable)e);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_ReadWSDL_UsingWSDL4J() throws Exception {
        Node node = null;
        try {
            node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition def = reader.readWSDL("http://localhost:8095/services/adminExternalEndpoint?wsdl");
            Assert.assertNotNull((Object)def);
            Assert.assertEquals((int)1, (int)def.getServices().size());
        }
        finally {
            if (node != null) {
                node.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

