/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Document;

public class ESBUserManagementTest {
    private Logger log = Logger.getLogger(ESBUserManagementTest.class.getName());
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);
    private static String ADMIN_ADDRESS = "http://localhost:8095/services/adminExternalEndpoint";
    private static ObjectFactory objectFactory = new ObjectFactory();

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        try {
            node.start();
        }
        catch (TransportException e) {
            throw new ESBException((Throwable)e);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserManagement_bind() throws ManagementException, ESBException, TransportException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            String response = client.bind("http://localhost:9001/echo", "classpath://wsdl/echo.wsdl");
            Assert.assertEquals((Object)"esb://http://ws.easyesb.ebmwebsourcing.com/echo/::echo@echoSOAP?type=ProviderProxyEndpoint", (Object)response);
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserManagement_expose() throws ManagementException, ESBException, TransportException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            String responseBind = client.bind("http://localhost:9001/echo", "classpath://wsdl/echo.wsdl");
            Assert.assertEquals((Object)"esb://http://ws.easyesb.ebmwebsourcing.com/echo/::echo@echoSOAP?type=ProviderProxyEndpoint", (Object)responseBind);
            String responseExpose = client.expose(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo"), "echoSOAP");
            Assert.assertEquals((Object)"http://localhost:8095/services/echoSOAPClientProxyEndpoint", (Object)responseExpose);
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserManagement_proxify() throws ManagementException, ESBException, TransportException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            String response = client.proxify("http://localhost:9001/echo", "classpath://wsdl/echo.wsdl");
            Assert.assertEquals((Object)"http://localhost:8095/services/echoSOAPClientProxyEndpoint", (Object)response);
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testUserManagement_deploy() throws ManagementException, ESBException, TransportException, URISyntaxException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            String bpelFileName = "process.bpel";
            File folder = new File(Thread.currentThread().getContextClassLoader().getResource("bpel/deploy/travelagency").toURI());
            File bpel = new File(folder, bpelFileName);
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("wsdl") || name.endsWith("xsd");
                }
            });
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            EJaxbDeployementReport response = client.deploy(bpel, files);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals(EJaxbBpelReport.class, response.getAny().getClass());
            Assert.assertEquals((long)1L, (long)((EJaxbBpelReport)response.getAny()).getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/travelAgencyServiceEndpoint_proxy", ((EJaxbBpelReport)response.getAny()).getExternalEndpointsAddressesCreated().get(0));
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminManagement_deployFromURL() throws ManagementException, ESBException, TransportException, URISyntaxException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            EJaxbDeployementReport response = client.deploy(Thread.currentThread().getContextClassLoader().getResource("bpel/travelagency/process.bpel"));
            Assert.assertNotNull((Object)response);
            Assert.assertEquals(EJaxbBpelReport.class, response.getAny().getClass());
            Assert.assertEquals((long)1L, (long)((EJaxbBpelReport)response.getAny()).getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/travelAgencyServiceEndpoint_proxy", ((EJaxbBpelReport)response.getAny()).getExternalEndpointsAddressesCreated().get(0));
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserManagement_subscribe() throws ManagementException, ESBException, TransportException, NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault, UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, UnrecognizedPolicyRequestFault, TopicNotSupportedFault, InvalidProducerPropertiesExpressionFault, ResourceUnknownFault, InvalidMessageContentExpressionFault, WsnbException {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            Subscribe payload = WSNHelper.createSubscription((String)"http://subscriptionClient.com/", (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "res"), (QName[])new QName[0]);
            Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload);
            EJaxbSubscribe subscribeValid = WSNHelper.convert2JaxbElement((Subscribe)payload);
            EJaxbSubscribeResponse response = client.subscribe(subscribeValid);
            Document doc2 = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
            System.out.println(XMLPrettyPrinter.prettyPrint((Document)doc2));
            Assert.assertNotNull((Object)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="TODO")
    public void testUserManagement_unsubscribe() throws ManagementException, ESBException, TransportException, NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault, UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, UnrecognizedPolicyRequestFault, TopicNotSupportedFault, InvalidProducerPropertiesExpressionFault, ResourceUnknownFault, InvalidMessageContentExpressionFault, UnableToDestroySubscriptionFault {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            EJaxbUnsubscribe request = new EJaxbUnsubscribe();
            EJaxbUnsubscribeResponse response = client.unsubscribe(request);
            Assert.assertNotNull((Object)response);
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserManagement_getResourceProperty() throws ManagementException, ESBException, TransportException, NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault, UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, UnrecognizedPolicyRequestFault, TopicNotSupportedFault, InvalidProducerPropertiesExpressionFault, ResourceUnknownFault, InvalidMessageContentExpressionFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            UserManagementClientSOAP client = new UserManagementClientSOAP(ADMIN_ADDRESS);
            QName property = new QName("http://docs.oasis-open.org/wsn/t-1", "TopicSet");
            EJaxbGetResourcePropertyResponse response = client.getResourceProperty(property);
            Assert.assertNotNull((Object)response);
        }
        finally {
            node.stop();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

