/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl.test;

import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.util.Util;
import com.ebmwebsourcing.easyesb.soa10.api.element.Node;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ESBUtilTest {
    private Logger log = Logger.getLogger(ESBUtilTest.class.getName());

    @Test
    public void testGetNodeInformations() throws SOAPException, SAXException, IOException, ParserConfigurationException, Exception {
        Document nodeInfo = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new File(new File(".") + "/src/test/resources/util/GetNodeInformationsResponse.xml"));
        Element payload = DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)nodeInfo));
        Document getInfo = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        getInfo.appendChild(getInfo.importNode(payload.cloneNode(true), true));
        System.out.println("doc = \n" + XMLPrettyPrinter.prettyPrint((Document)getInfo));
        Element nodeElmt = DOMUtil.getInstance().getFirstElement(getInfo.getDocumentElement());
        Document nodeDoc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        nodeDoc.appendChild(nodeDoc.importNode(nodeElmt.cloneNode(true), true));
        Node nodeModel = (Node)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readFragment(Util.convertDocumentToInputStream((Document)nodeDoc), Node.class);
        System.out.println("nodeModel = " + nodeModel);
        System.out.println("nodeModel.getRegistry() = " + nodeModel.getRegistry());
        for (EndpointType ep : nodeModel.getRegistry().getLocalEndpointsList().getEndpoints()) {
            System.out.println("ep.getName(): " + ep.getReference());
        }
        Assert.assertEquals((long)15L, (long)nodeModel.getRegistry().getLocalEndpointsList().getEndpoints().length);
    }
}

