/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.esb;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.Holder;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;

import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;

public class Main4JProfiler {

	private Logger log = Logger.getLogger(Main4JProfiler.class.getName());

	private AdminClient client = null;

	private static int i = 0;

	public Main4JProfiler() throws Exception {
		this.client = new AdminClientImpl("http://localhost:8085/services/adminExternalEndpoint");
	}


	private Node createNode(QName name, boolean explorer, String host, int port, int soap_port) throws ESBException {
		ESBFactory factory = new ESBFactoryImpl();
		Node node = factory.createNode(name, new ConfigurationImpl(explorer, host, port, new SoapServer(new SoapServerConfig(soap_port))));

		return node;
	}

	private void runStoreBpel() throws Exception {
		Node node  = createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), false, "localhost", 9010, 8085); 

		try {
			System.out.println("********************* File: " + new File("D:\\bpel\\travelagency\\process.bpel").toURI().toString());
			System.out.println("********************* File: " + new File("D:\\bpel\\travelagency\\process.bpel").exists());
			StoreBpelResponse businessReponse = storeBpel(new File("D:\\bpel\\travelagency\\process.bpel").toURI().toString(), 8085);



		}	finally {
			node.stop();
		}

	}

	public void testAdminEndpoint_CreateComponent() throws Exception {
		Node node  = createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), false, "localhost", 9010, 8085);

		//Thread.sleep(1000000000);

		try {
			createComponent();
		}	finally {
			node.stop();
		}
	}

	private void createComponent() throws AdminExceptionMsg {
		Holder<QName> componentName = new Holder<QName>(new QName("http://com.ebmwebsourcing.easyesb", "MyComponent" + (i++)));
		this.client.createComponent(componentName, ComponentImpl.class.getName());
	}


	private StoreBpelResponse storeBpel(String resourceUrl, int soap_port) throws SOAPException, SAXException, IOException,
	ParserConfigurationException, Exception {
		SOAPSender sender = new SOAPSender();

		// store bpel
		StoreBpel payload = new StoreBpel();
		payload.setBpelUrl(resourceUrl);
		Document soapRequest = SOAPSender.createSOAPMessageRequest(SOAJAXBContext.getInstance().unmarshallAnyElement(payload));
		Document soapResponse = sender.sendSoapRequest(soapRequest, "http://localhost:" + soap_port + "/services/adminExternalEndpoint", "http://com.ebmwebsourcing.easyesb/Admin/storeBpel");

		// print response
		String responseMsg = XMLPrettyPrinter.prettyPrint(soapResponse);
		System.out.println("response = " + responseMsg);

		Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
		doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody(soapResponse)), true).cloneNode(true));
		System.out.println("payload = " + XMLPrettyPrinter.prettyPrint(doc));

		StoreBpelResponse businessReponse = SOAJAXBContext.getInstance().marshallAnyType(doc, StoreBpelResponse.class);
		return businessReponse;
	}

	public static void main(String[] args)throws Exception  {
		Main4JProfiler m = new Main4JProfiler();

		while (i < 50) {
			m.testAdminEndpoint_CreateComponent();
		}

		System.out.println("FINISH!!!");
	}
}
