/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cdk;

import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import javax.xml.namespace.QName;

public class ESBHelper {
    public static Component<?> createComponent(Node<?> node, QName name, Class<? extends ComponentBehaviour> ... behaviours) throws ESBException {
        Component myComponent = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(name, ComponentImpl.class);
        for (Class<? extends ComponentBehaviour> behaviour : behaviours) {
            myComponent.addBehaviourClass(behaviour);
        }
        return myComponent;
    }

    public static String exposeAsWS(Node<?> node, ProviderEndpoint<?> ep) throws ESBException {
        SoapServer soapServer = (SoapServer)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
        if (soapServer == null) {
            throw new ESBException("Soap server cannot be null");
        }
        ClientProxyEndpoint clientEndpoint = (ClientProxyEndpoint)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName(ep.getQName().getNamespaceURI(), ep.getQName().getLocalPart() + "ExternalEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, null);
        clientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
        clientEndpoint.setProviderServiceName(((ProviderEndpointType)ep.getModel()).getService());
        clientEndpoint.setProviderEndpointName(ep.getQName());
        clientEndpoint.setExternalAddress("http://" + soapServer.getConfig().getHost() + ":" + soapServer.getConfig().getPort() + "/services/" + clientEndpoint.getQName().getLocalPart() + "/");
        assert (clientEndpoint.getDescription() != null);
        SOAPListenerImpl soapListener = new SOAPListenerImpl(clientEndpoint, soapServer);
        clientEndpoint.getExternalListeners().put("SOAP", soapListener);
        ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).setAdminExternalEndpoint(clientEndpoint.getExternalAddress());
        return clientEndpoint.getExternalAddress();
    }
}

