/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.launcher;

import com.ebmwebsourcing.easyesb.launcher.Launcher;
import com.ebmwebsourcing.easyesb.launcher.util.CommandReader;
import com.ebmwebsourcing.easyesb.launcher.util.Locker;
import com.ebmwebsourcing.easyesb.launcher.util.SystemExitHook;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.ESBKernelFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;

public abstract class AbstractNodeLauncher
implements Launcher {
    private static final String START_COMMAND = "start";
    private static final String SHUTDOWN_COMMAND = "shutdown";
    private static final String VERSION_COMMAND = "version";
    protected ESBKernelFactory factory = null;
    private String banner = " -----------------------------------------------------------\n|                                                           |\n|                          EasyESB                          |\n|             EBM Research Enterprise Service Bus           |\n|               http://research.petalslink.org              |\n|                                                           |\n -----------------------------------------------------------\n";
    private static final String LOGGER_FILE = "/logger/easyesb-logging.properties";
    private Node petalsServer;
    private SystemExitHook systemExitHook;
    private final Locker locker = new Locker(new File("."));

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("ESB is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("ESB is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.petalsServer);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new ESBException("Can not start the ESB server, remove lock file from ESB root path or stop server");
        }
        this.locker.lock();
        this.petalsServer = this.getFactory().createNode(new QName("http://ow2.petals.org", "node0"), this.getFactory().getDefaultConfiguration());
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the ESB container");
        System.out.println(" -shutdowm               shutdown the ESB container");
        System.out.println(" -version                get the ESB container version");
    }

    private void printStartedMessage() {
        this.printSpecificStartMessage();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        System.out.println();
        System.out.println("ESB " + this.getDistributionName() + " distribution successfully started - " + sdf.format(date));
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(Node node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }

    protected abstract String getDistributionName();

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/easyesb-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : AbstractNodeLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

