/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.soap.test;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPSenderImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.element.SenderInitialisation;
import com.ebmwebsourcing.easyesb.ws.echo.EchoResponse;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import com.ebmwebsourcing.easyesb.ws.echo.test.Echo_EchoSOAP_Server;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class SOAPSenderTest
extends TestCase {
    private EndpointInitialContext context = null;

    protected void setUp() throws Exception {
        this.context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, String host, int port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port);
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSoapSender() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010);
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            new Echo_EchoSOAP_Server();
            System.out.println("Server ready...");
            Thread.sleep(1000L);
            Service providerService = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/echo/", "echo"), BusinessServiceImpl.class);
            SenderInitialisation senderInit = (SenderInitialisation)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(SenderInitialisation.class);
            senderInit.setClassName(SOAPSenderImpl.class.getName());
            senderInit.setExternalProviderAddress("http://localhost:9001/echo");
            ProviderProxyEndpoint providerEndpoint = (ProviderProxyEndpoint)((ServiceBehaviour)providerService.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("echoSOAP", ProviderProxyEndpointImpl.class, ProviderProxyBehaviourImpl.class, this.context, new SenderInitialisation[]{senderInit});
            providerEndpoint.setWSDLDescriptionAddress(Thread.currentThread().getContextClassLoader().getResource("wsdl/echo.wsdl").toURI());
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://petals.ow2.org/echo", "myClientEchoEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setInterfaceName(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo"));
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((String)"Hello world!!!", (String)businessReponse.getOut());
        }
        finally {
            node.stop();
        }
    }
}

