/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ProviderProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;

public class SoapProviderProxyBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements ProviderProxyBehaviour {
    private static Logger log = Logger.getLogger(SoapProviderProxyBehaviourImpl.class.getName());

    public SoapProviderProxyBehaviourImpl(ProviderProxyEndpoint ep) throws SOAPException {
        super((com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint)ep);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            this.sendExchange2ExternalProviderEndpoint(exchange);
        }
        catch (TransportException e) {
            log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress() + "\nendpoint: " + ((ProviderProxyEndpoint)this.endpoint).getQName() + "\nDescription:" + this.endpoint.getDescription().getDocumentBaseURI());
            throw new TransportException((Throwable)e);
        }
    }

    public Exchange sendExchange2ExternalProviderEndpoint(Exchange exchange) throws TransportException {
        try {
            org.w3c.dom.Document request = SOAPSender.createSOAPMessageRequest((org.w3c.dom.Document)exchange.getMessageIn().getBody().getPayload());
            String soapAction = this.findSoapAction(this.getEndpoint().getDescription(), exchange);
            SOAPSender sender = new SOAPSender();
            org.w3c.dom.Document response = sender.sendSoapRequest(request, ((ProviderProxyEndpoint)this.endpoint).getExternalAddress(), soapAction);
            if (exchange.getPattern().equals((Object)PatternType.IN_OUT)) {
                this.setExchangeFromSoapResponse(exchange, response);
            }
        }
        catch (UnsupportedOperationException e) {
            log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
            throw new TransportException((Throwable)e);
        }
        catch (ESBException e) {
            log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
            throw new TransportException((Throwable)e);
        }
        catch (JDOMException e) {
            log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
            throw new TransportException((Throwable)e);
        }
        catch (SOAPException e) {
            log.severe("Impossiblle to send message to: " + ((ProviderProxyEndpoint)this.endpoint).getExternalAddress());
            throw new TransportException((Throwable)e);
        }
        return exchange;
    }

    private String findSoapAction(Description description, Exchange exchange) throws ESBException {
        String soapAction = null;
        List eps = description.findEndpointsImplementingInterface(description.findInterface(exchange.getInterfaceName()));
        if (eps.size() != 1) {
            throw new ESBException("Impossible to find endpoint corresponding to this interface: " + exchange.getInterfaceName());
        }
        org.petalslink.abslayer.service.api.BindingOperation bop = ((Endpoint)eps.get(0)).getBinding().getOperationByName(QName.valueOf(exchange.getOperation()).getLocalPart());
        soapAction = SoapBindingHelper.getSoapOperation((BindingOperation)((BindingOperation)bop.getModel())).getSoapAction();
        return soapAction;
    }

    private void setExchangeFromSoapResponse(Exchange exchange, org.w3c.dom.Document soapResponse) throws ESBException {
        try {
            org.w3c.dom.Document domBody;
            Body bodyE;
            List bodies;
            org.w3c.dom.Document domHeader;
            Header headerE;
            DOMBuilder builder = new DOMBuilder();
            Document soapResp = builder.build(soapResponse);
            if (exchange.getMessageOut() == null) {
                MessageOut msgOut = (MessageOut)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
                exchange.setMessageOut(msgOut);
            }
            DOMOutputter converter = new DOMOutputter();
            List headers = soapResp.getRootElement().getChildren("Header", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/"));
            if (headers != null && headers.size() == 1) {
                if (exchange.getMessageOut().getHeader() == null) {
                    headerE = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                    exchange.getMessageOut().setHeader(headerE);
                }
                for (Element elmt : headers) {
                    domHeader = converter.output(new Document((Element)elmt.detach()));
                    exchange.getMessageOut().getHeader().addProperty(domHeader);
                }
            } else {
                headers = soapResp.getRootElement().getChildren("Header");
                if (headers != null && headers.size() == 1) {
                    if (exchange.getMessageOut().getHeader() == null) {
                        headerE = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                        exchange.getMessageOut().setHeader(headerE);
                    }
                    for (Element elmt : headers) {
                        domHeader = converter.output(new Document((Element)elmt.detach()));
                        exchange.getMessageOut().getHeader().addProperty(domHeader);
                    }
                }
            }
            if ((bodies = soapResp.getRootElement().getChildren("Body", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/"))) != null && bodies.size() == 1 && ((Element)bodies.get(0)).getChildren().size() >= 1 && ((Element)bodies.get(0)).getChildren("Fault", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/")).size() > 0) {
                if (exchange.getMessageOut().getBody() == null) {
                    bodyE = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    exchange.getMessageOut().setBody(bodyE);
                }
                Element fault = (Element)((Element)bodies.get(0)).getChildren("Fault", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/soap/envelope/")).get(0);
                org.w3c.dom.Document domError = converter.output(new Document((Element)fault.detach()));
                MessageUtil.getInstance().createErrorMessageStructure(exchange);
                exchange.getMessageError().getBody().setPayload(domError);
            } else if (bodies != null && bodies.size() == 1) {
                if (((Element)bodies.get(0)).getChildren().size() >= 1) {
                    if (exchange.getMessageOut().getBody() == null) {
                        bodyE = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                        exchange.getMessageOut().setBody(bodyE);
                    }
                    domBody = converter.output(new Document((Element)((Element)((Element)bodies.get(0)).getChildren().get(0)).detach()));
                    exchange.getMessageOut().getBody().setPayload(domBody);
                }
            } else {
                bodies = soapResp.getRootElement().getChildren("Body");
                if (((Element)bodies.get(0)).getChildren().size() >= 1) {
                    if (exchange.getMessageOut().getBody() == null) {
                        bodyE = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                        exchange.getMessageOut().setBody(bodyE);
                    }
                    domBody = converter.output(new Document((Element)((Element)((Element)bodies.get(0)).getChildren().get(0)).detach()));
                    exchange.getMessageOut().getBody().setPayload(domBody);
                }
            }
        }
        catch (JDOMException e) {
            throw new ESBException((Throwable)e);
        }
    }
}

