/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport.endpoint.RawReportSubscriptionEndpoint;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.TimeStamper;
import com.ebmwebsourcing.easyesb.rawreport.service.RawReportSubscriptionServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.TechnicalService;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa.impl.test.util.EchoBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.element.SenderInitialisation;
import com.ebmwebsourcing.easyesb.util.NotificationConsumerMock;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.notifier.NotificationConsumerDecorator;
import org.ow2.petals.notifier.NotificationConsumer_NotifierEndpoint_Server;
import org.w3c.dom.Document;

public class ReportInterceptorTest {
    private static Logger log = Logger.getLogger(ReportInterceptorTest.class.getName());
    private static final String RAW_REPORT_ENDPOINT = "http://localhost:8200/rawReportEndpointClientProxyEndpoint";
    private EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);

    public ReportInterceptorTest() throws Exception {
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, boolean explorer, String host, int port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, "8184");
            }
        });
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testSynchronousInOutSend() throws Exception {
        boolean explorer = false;
        Node node = null;
        NotificationConsumer_NotifierEndpoint_Server notifServer = null;
        try {
            node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), explorer, "localhost", 9001);
            Service service = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/wheather", "weather"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myWeatherEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/wheather", "myClientWheatherEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            NotificationConsumerMock notifier = new NotificationConsumerMock();
            notifServer = new NotificationConsumer_NotifierEndpoint_Server((NotificationConsumerDecorator)notifier, "http://localhost:9600/RawReportService");
            TechnicalService reportService = (TechnicalService)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getService(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(node.getQName().getNamespaceURI(), node.getQName().getLocalPart() + "_rawreport"), null, new QueryParam[0])));
            System.out.println("ps : " + ((RawReportSubscriptionServiceBehaviour)reportService.findBehaviour(RawReportSubscriptionServiceBehaviour.class)).getProviderEndpoints());
            RawReportSubscriptionEndpoint reportEndpoint = (RawReportSubscriptionEndpoint)((RawReportSubscriptionServiceBehaviour)reportService.findBehaviour(RawReportSubscriptionServiceBehaviour.class)).getProviderEndpoint(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(node.getQName().getNamespaceURI(), node.getQName().getLocalPart() + "_rawreport"), "rawReportEndpoint_" + node.getQName().getLocalPart(), new QueryParam[0])));
            Exchange exchangeSubscription = this.createSubscriptionExchange((ProviderEndpoint)reportEndpoint, clientEndpoint, "http://localhost:9600/RawReportService");
            Exchange responseSubscription = clientEndpoint.sendSync(exchangeSubscription, 0L);
            Assert.assertNotNull((Object)responseSubscription.getMessageOut().getBody());
            Exchange exchange = this.createFunctionalExchange(providerEndpoint, clientEndpoint);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("msg In = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageIn().printMessage()));
            System.out.println("msg out = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().printMessage()));
            log.info("msg In = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageIn().printMessage()));
            log.info("msg out = " + XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().printMessage()));
            Assert.assertEquals((Object)"hello world!!!", (Object)response.getMessageOut().getBody().getPayload().getDocumentElement().getFirstChild().getFirstChild().getNodeValue());
            Assert.assertNotNull((Object)response.getMessageIn().getHeader().getProperty(TimeStamper.DATE_CLIENT_IN_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageIn().getHeader().getProperty(TimeStamper.DATE_PROVIDER_IN_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageOut().getHeader().getProperty(TimeStamper.DATE_CLIENT_OUT_PROPERTY));
            Assert.assertNotNull((Object)response.getMessageOut().getHeader().getProperty(TimeStamper.DATE_PROVIDER_OUT_PROPERTY));
            while (notifier.getNotifications().size() < 3) {
                Thread.sleep(200L);
            }
            int i = 0;
            for (EJaxbNotify notify : notifier.getNotifications()) {
                Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify);
                System.out.println("########" + i + "#########\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                ++i;
            }
            Assert.assertEquals((long)3L, (long)notifier.getNotifications().size());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            if (notifServer != null) {
                notifServer.shutdown();
            }
        }
    }

    private Exchange createFunctionalExchange(ProviderEndpoint providerEndpoint, ClientEndpoint clientEndpoint) throws ExchangeException, SOAException {
        Exchange exchange = clientEndpoint.createExchange();
        exchange.setDestinationReference(providerEndpoint.getReference());
        exchange.setPattern(PatternType.IN_OUT);
        exchange.setStatus(StatusType.ACTIVE);
        exchange.setOperation(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo").toString());
        SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory.class});
        Echo_Type echo = new Echo_Type();
        echo.setIn("hello world!!!");
        MessageUtil.getInstance().createInMessageStructure(exchange);
        exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo));
        return exchange;
    }

    private Exchange createSubscriptionExchange(ProviderEndpoint providerEndpoint, ClientEndpoint clientEndpoint, String address) throws Exception {
        Exchange exchange = clientEndpoint.createExchange();
        exchange.setDestinationReference(providerEndpoint.getReference());
        exchange.setPattern(PatternType.IN_OUT);
        exchange.setStatus(StatusType.ACTIVE);
        exchange.setOperation(new QName("http://docs.oasis-open.org/wsn/b-2", "Subscribe").toString());
        Subscribe sub = WSNHelper.createSubscription((String)address, (QName)new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "bsm"), (QName[])new QName[0]);
        Document doc = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(sub);
        MessageUtil.getInstance().createInMessageStructure(exchange);
        exchange.getMessageIn().getBody().setPayload(doc);
        return exchange;
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

