/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import java.util.logging.Logger;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ClientReportInterceptor extends AbstractReportInterceptor implements ClientEndpointInvocationInterceptor {

	private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());

	private Configuration conf;

	public ClientReportInterceptor(Configuration conf, Endpoint endpoint) throws ESBException {
		super(endpoint);
		this.conf = conf;
	}





	public void processingExchangeAfterReceiving(Exchange exchange)
			throws TransportException {
		this.log.finest("t4: report interception to be sent for exchange "+exchange.getUuid());


		if(exchange != null) {
			this.log.finest("t4: report exchange not null");
			ReportList reports = createReportListFromExchangeT3T4(exchange);
			this.log.finest("t4: reports created ");
			if(reports.getReports().length > 0) {
				this.log.finest("t4: reports sent ...");
				try {
					this.sendReport(reports);
				} catch (ESBException e) {
					// do nothing
					e.printStackTrace();
				}
			}

		} else {
			// TODO: generate report for timeout error
			log.severe("ERROR: TIMEOUT => Impossible to create report");
		}


	}



	//t1
	public void processingExchangeBeforeSending(Exchange exchange)
			throws TransportException {

	}



}
