/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

import javax.xml.parsers.ParserConfigurationException;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;

public class ThreadReport extends Thread {

	private static final String ADD_NEW_REPORTLIST_SOAPACTION = "http://com.ebmwebsourcing.service/esrawreport/addNewReportList";

	/**
	 * Logger wrapper.
	 */
	private static Logger log = Logger.getLogger(ThreadReport.class.getName());
	
	private String address;
	
	private ReportList reportList = null;

	private SOAPSender sender = new SOAPSender();
	
	
	@Override
	public void run() {
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(this.getReportList(), baos);
			ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
			Document request = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
			
			Document soapRequest = createSOAPMessageRequest(request);
			baos.close();
			this.sender.sendSoapRequest(soapRequest, address, ADD_NEW_REPORTLIST_SOAPACTION);
			log.info("reports sent at " + address + " - exchange id: " + this.getReportList().getReports()[0].getExchangeId());
		} catch (JDOMException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} catch (SOAPException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} catch (SAXException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} catch (XmlObjectWriteException e) {
			log.warning("************************* WARNING IN SEND: " + e.getMessage());
			e.printStackTrace();
		} 
	}
	
	private static Document createSOAPMessageRequest(Document msg) throws JDOMException {
		Document res = null;

		Element env = new Element("Envelope", Namespace.getNamespace("soap-env", "http://schemas.xmlsoap.org/soap/envelope/"));
		env.addNamespaceDeclaration(Namespace.getNamespace("xsd", "http://www.w3.org/1999/XMLSchema"));
		env.addNamespaceDeclaration(Namespace.getNamespace("xsi", "http://www.w3.org/1999/XMLSchema-instance"));
		org.jdom.Document jdom = new org.jdom.Document(env);

		Element body = new Element("Body", Namespace.getNamespace("soap-env", "http://schemas.xmlsoap.org/soap/envelope/"));
		env.addContent(body);
		
		
		DOMBuilder builder = new DOMBuilder();
		org.jdom.Document jdomDocument = builder.build(msg);

		body.addContent(((Element)jdomDocument.getRootElement()).detach());

		DOMOutputter converter = new DOMOutputter();
		res = converter.output(jdom);

		return res;
	}


	public String getAddress() {
		return address;
	}


	public void setAddress(String address) {
		this.address = address;
	}


	public ReportList getReportList() {
		if(this.reportList == null) {
			this.reportList = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ReportList.class);
		}
		return reportList;
	}
	
	public void setReportList(ReportList reportList) {
		this.reportList = reportList;
	}

}
