/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.initialization;


import com.ebmwebsourcing.easyesb.rawreport.interceptor.report.ClientReportInterceptor;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.report.ProviderReportInterceptor;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.ClientTimeStampInterceptor;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.timestamp.ProviderTimeStampInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.AbstractEndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;

public class RawReportIntializationInterceptor extends AbstractEndpointInitializationInterceptor implements EndpointInitializationInterceptor {

	public static final String RAWREPORT_ENDPOINT_CREATION_SERVICE_ADDRESS_PROPERTY = "rawreport-endpoint-creation-service-address";
	
	public static final String RAWREPORT_SERVICE_ADDRESS_PROPERTY = "rawreport-service-address";

	public RawReportIntializationInterceptor(Endpoint ep) {
		super(ep);
	}


	public void processingCreation() throws ESBException {
		
		Configuration conf = ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration();
		
		if(this.endpoint instanceof ClientEndpoint) {
			((ClientEndpoint)this.endpoint).getStub().addClientEndpointInvocationInterceptor(new ClientTimeStampInterceptor());
			((ClientEndpoint)this.endpoint).getStub().addClientEndpointInvocationInterceptor(new ClientReportInterceptor(conf, this.endpoint));
		}
		if(this.endpoint instanceof ProviderEndpoint) {
			((ProviderEndpoint)this.endpoint).getSkeleton().addProviderEndpointInvocationInterceptor(new ProviderTimeStampInterceptor());
			((ProviderEndpoint)this.endpoint).getSkeleton().addProviderEndpointInvocationInterceptor(new ProviderReportInterceptor(conf, this.endpoint));
		}
		
	}

}
