/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import java.util.logging.Logger;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ProviderReportInterceptor extends AbstractReportInterceptor implements ProviderEndpointInvocationInterceptor {

    private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());

    private Configuration conf;


    public ProviderReportInterceptor(Configuration conf, Endpoint endpoint) throws ESBException {
        super(endpoint);
        this.conf = conf;
    }

    @Override
    public void processingExchangeBeforeSending(Exchange ex) throws TransportException {
        // TODO Auto-generated method stub

    }

    @Override
    public void processingExchangeAfterReceiving(Exchange exchange) throws TransportException {

        this.log.finest("t2: report interception");

        Document sourNodeInfo =  exchange.getMessageIn().getHeader().getProperty(SourceNodeInformations.QNAME);
        if(sourNodeInfo != null){
            SourceNodeInformations sourNodeInfoModel = null;
            try {
                sourNodeInfoModel = SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(sourNodeInfo, SourceNodeInformations.class);
            } catch (Exception e) {

                e.printStackTrace();
                log.warning("Failed to retrieve sourceNodeInformation to get services Information");
            }

        }
        this.log.finest("t2: report sent for exchange "+exchange.getUuid());

        if(exchange != null) {
            this.log.finest("t2: report exchange not null");
            ReportList reports = createReportListFromExchangeT1T2(exchange);
            this.log.finest("t2: reports created");


            if(reports.getReports().length > 0) {
                this.log.finest("t2: reports sent ...");
                try {
                    this.sendReport(reports);
                } catch (ESBException e) {
                    // do nothing
                    e.printStackTrace();
                }
            }
        } else {
            // TODO: generate report for timeout error
            this.log.severe("ERROR: TIMEOUT => Impossible to create report");
        }


    }



}
