/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.api.util;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyschema10.api.element.Include;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ImportUtil {
    private static ImportUtil INSTANCE = null;

    private ImportUtil() {
    }

    public static ImportUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImportUtil();
        }
        return INSTANCE;
    }

    public Document findImportInDescription(Description desc, String relativePath) throws XmlObjectWriteException {
        Document res;
        block4: {
            res = null;
            URI absolute = null;
            try {
                absolute = URI.create(relativePath);
                if (absolute.isAbsolute() || "jar".equals(absolute.getScheme())) {
                    InputStream is = absolute.toURL().openStream();
                    res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
                    is.close();
                } else {
                    Definitions def = (Definitions)desc.getModel();
                    res = this.findAllURIInDescription(def, relativePath);
                }
            }
            catch (Throwable e) {
                res = this.findInClassPath(absolute, e);
                if (res != null) break block4;
                throw new XmlObjectWriteException(e);
            }
        }
        return res;
    }

    private Document findInClassPath(URI absolute, Throwable e) throws XmlObjectWriteException {
        Document res = null;
        if (absolute.toString().equals("http://www.w3.org/2005/08/addressing/ws-addr.xsd")) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResource("schema/wsaddressing10/wsaddressing10.xsd").openStream();
                res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
                is.close();
            }
            catch (Exception e1) {
                throw new XmlObjectWriteException(e);
            }
        }
        if (absolute.toString().equals("http://docs.oasis-open.org/wsrf/bf-2.xsd")) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/bf-2.xsd").openStream();
                res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
                is.close();
            }
            catch (Exception e1) {
                throw new XmlObjectWriteException(e);
            }
        }
        if (absolute.toString().equals("http://www.w3.org/2001/xml.xsd")) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/xml.xsd").openStream();
                res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
                is.close();
            }
            catch (Exception e1) {
                throw new XmlObjectWriteException(e);
            }
        }
        if (absolute.toString().equals("http://docs.oasis-open.org/wsn/t-1.xsd")) {
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/t-1.xsd").openStream();
                res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
                is.close();
            }
            catch (Exception e1) {
                throw new XmlObjectWriteException(e);
            }
        }
        return res;
    }

    private Document findImportAndIncludeInSchema(Schema s, String relativePath) throws ParserConfigurationException, XmlObjectWriteException {
        Document res;
        block6: {
            Schema imptSchema;
            res = null;
            ArrayList<Schema> imptSchemas = new ArrayList<Schema>();
            for (com.ebmwebsourcing.easyschema10.api.element.Import import_ : s.getImports()) {
                if (!(import_.getXmlObjectAdoptedChildren()[0] instanceof Schema)) continue;
                imptSchema = (Schema)import_.getXmlObjectAdoptedChildren()[0];
                if (!(import_.getXmlObjectAdoptedChildren()[0] instanceof Schema)) continue;
                if (import_.getSchemaLocation().equals(relativePath)) {
                    res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)imptSchema, (Node)res);
                    break;
                }
                imptSchemas.add(imptSchema);
            }
            if (res != null) break block6;
            for (com.ebmwebsourcing.easyschema10.api.element.Import import_ : s.getIncludes()) {
                if (!(import_.getXmlObjectAdoptedChildren()[0] instanceof Schema)) continue;
                imptSchema = (Schema)import_.getXmlObjectAdoptedChildren()[0];
                if (import_.getSchemaLocation().equals(relativePath)) {
                    res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)imptSchema, (Node)res);
                    break;
                }
                imptSchemas.add(imptSchema);
            }
            if (res == null) {
                Schema imptSchema2;
                Iterator i$ = imptSchemas.iterator();
                while (i$.hasNext() && (res = this.findImportAndIncludeInSchema(imptSchema2 = (Schema)i$.next(), relativePath)) == null) {
                }
            }
        }
        return res;
    }

    private Document findAllURIInDescription(Definitions def, String relativePath) throws ParserConfigurationException, XmlObjectWriteException {
        Document res;
        block11: {
            Definitions imptdef;
            res = null;
            ArrayList<Definitions> imptdefs = new ArrayList<Definitions>();
            ArrayList<Schema> imptSchemas = new ArrayList<Schema>();
            for (Import import_ : def.getImports()) {
                if (!(import_.getXmlObjectAdoptedChildren()[0] instanceof Definitions)) continue;
                Definitions imptdef2 = (Definitions)import_.getXmlObjectAdoptedChildren()[0];
                if (import_.getLocation().equals(relativePath)) {
                    res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)imptdef2, (Node)res);
                    break;
                }
                imptdefs.add(imptdef2);
            }
            if (res == null && def.getTypes() != null) {
                for (Import import_ : def.getTypes().getAnyXmlObjects()) {
                    Schema imptSchema;
                    com.ebmwebsourcing.easyschema10.api.element.Import impt;
                    if (import_ instanceof Schema) {
                        imptSchemas.add((Schema)import_);
                        continue;
                    }
                    if (import_ instanceof com.ebmwebsourcing.easyschema10.api.element.Import) {
                        impt = (com.ebmwebsourcing.easyschema10.api.element.Import)import_;
                        if (!(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema)) continue;
                        imptSchema = (Schema)impt.getXmlObjectAdoptedChildren()[0];
                        if (impt.getSchemaLocation().equals(relativePath)) {
                            res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)imptSchema, (Node)res);
                            break;
                        }
                        imptSchemas.add(imptSchema);
                        continue;
                    }
                    if (!(import_ instanceof Include) || !((impt = (Include)import_).getXmlObjectAdoptedChildren()[0] instanceof Schema)) continue;
                    imptSchema = (Schema)impt.getXmlObjectAdoptedChildren()[0];
                    if (impt.getSchemaLocation().equals(relativePath)) {
                        res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                        ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasyESBFramework.getInstance()).get()).writeDocument((XmlObject)imptSchema, (Node)res);
                        break;
                    }
                    imptSchemas.add(imptSchema);
                }
            }
            if (res != null) break block11;
            Iterator i$ = imptdefs.iterator();
            while (i$.hasNext() && (res = this.findAllURIInDescription(imptdef = (Definitions)i$.next(), relativePath)) == null) {
            }
            if (res == null) {
                Schema imptSchema;
                i$ = imptSchemas.iterator();
                while (i$.hasNext() && (res = this.findImportAndIncludeInSchema(imptSchema = (Schema)i$.next(), relativePath)) == null) {
                }
            }
        }
        return res;
    }
}

