/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.component;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;

import easyesb.ebmwebsourcing.com.soa.model.component.ComponentBehaviourItf;

public interface ComponentBehaviour extends EndpointBehaviour, ComponentBehaviourItf {
	
	public static String DESCRIPTION_URL = "wsdl/componentEndpointBehaviour.wsdl";

	
	<S extends Service<? extends ServiceType>> S createService(QName name, Class<S> serviceClass) throws ESBException;
	
	List<Service<? extends ServiceType>> getServices();
	
	void addService(Service<? extends ServiceType> s);
	
	Service<? extends ServiceType> removeService(Service<? extends ServiceType> s) throws ESBException;
	
	Service<? extends ServiceType> getService(QName name);
}
