package com.ebmwebsourcing.easyesb.soa.api.util;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Import;

public class ImportUtil {

	private static ImportUtil INSTANCE = null;


	private ImportUtil() {

	}

	public static ImportUtil getInstance() {
		if(INSTANCE == null) {
			INSTANCE = new ImportUtil();
		}
		return INSTANCE;
	}
	
	
	public Document findImportInDescription(Description desc, String relativePath) throws XmlObjectWriteException {
		Document res = null;
		URI absolute = null;
		try {
			absolute = URI.create(relativePath);
			if(absolute.isAbsolute() || "jar".equals(absolute.getScheme())) {
				InputStream is = absolute.toURL().openStream();
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
			} else {
				Definitions def = (Definitions) desc.getModel();
				res = findAllURIInDescription(def, relativePath);
			}
		} catch (Throwable e) {
			// used for offline mode
			res = findInClassPath(absolute, e);
			if(res == null) {
				throw new XmlObjectWriteException(e);
			}
		}
		return res;
	}

	private Document findInClassPath(URI absolute, Throwable e)
			throws XmlObjectWriteException {
		Document res = null;
		if(absolute.toString().equals("http://www.w3.org/2005/08/addressing/ws-addr.xsd")) {
			try {
				InputStream is = Thread.currentThread().getContextClassLoader().getResource("schema/wsaddressing10/wsaddressing10.xsd").openStream();
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
			} catch (Exception e1) {
				throw new XmlObjectWriteException(e);
			} 
		} else if(absolute.toString().equals("http://docs.oasis-open.org/wsrf/bf-2.xsd")) {
			try {
				InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/bf-2.xsd").openStream();
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
			} catch (Exception e1) {
				throw new XmlObjectWriteException(e);
			} 
		} else if(absolute.toString().equals("http://www.w3.org/2001/xml.xsd")) {
			try {
				InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/xml.xsd").openStream();
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
			} catch (Exception e1) {
				throw new XmlObjectWriteException(e);
			} 
		}  else if(absolute.toString().equals("http://docs.oasis-open.org/wsn/t-1.xsd")) {
			try {
				InputStream is = Thread.currentThread().getContextClassLoader().getResource("schemas/t-1.xsd").openStream();
				res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
				is.close();
			} catch (Exception e1) {
				throw new XmlObjectWriteException(e);
			} 
		}
		return res;
	}

	private Document findImportAndIncludeInSchema(Schema s, String relativePath) throws ParserConfigurationException, XmlObjectWriteException {
		Document res = null;
		List<Schema> imptSchemas = new ArrayList<Schema>();
		for(com.ebmwebsourcing.easyschema10.api.element.Import impt: s.getImports()) {
			if(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema) {
				Schema imptSchema = (Schema) impt.getXmlObjectAdoptedChildren()[0];
				if(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema) {
					if(impt.getSchemaLocation().equals(relativePath)) {
						res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
						SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(imptSchema, res);
						break;
					} else {
						imptSchemas.add(imptSchema);
					}
				}
			}
		}
		if(res == null) {
			for(com.ebmwebsourcing.easyschema10.api.element.Include impt: s.getIncludes()) {
				if(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema) {
					Schema imptSchema = (Schema) impt.getXmlObjectAdoptedChildren()[0];
					if(impt.getSchemaLocation().equals(relativePath)) {
						res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
						SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(imptSchema, res);
						break;
					} else {
						imptSchemas.add(imptSchema);
					}
				}
			}
			if(res == null) {
				for(Schema imptSchema: imptSchemas) {
					res = findImportAndIncludeInSchema(imptSchema, relativePath);
					if(res != null) {
						break;
					}
				}
			}
		}
		return res;
	}

	private Document findAllURIInDescription(Definitions def, String relativePath) throws ParserConfigurationException, XmlObjectWriteException {
		Document res = null;
		List<Definitions> imptdefs = new ArrayList<Definitions>();
		List<Schema> imptSchemas = new ArrayList<Schema>();
		for(Import impt: def.getImports()) {
			if(impt.getXmlObjectAdoptedChildren()[0] instanceof Definitions) {
				Definitions imptdef = (Definitions) impt.getXmlObjectAdoptedChildren()[0];
				if(impt.getLocation().equals(relativePath)) {
					res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
					SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(imptdef, res);
					break;
				} else {
					imptdefs.add(imptdef);
				}
			}
		}

		if(res == null) {
			// find in schema
			if(def.getTypes() != null) {
				for(XmlObject obj: def.getTypes().getAnyXmlObjects()) {
					if(obj instanceof Schema) {
						imptSchemas.add((Schema)obj);
					} else if(obj instanceof com.ebmwebsourcing.easyschema10.api.element.Import) {
						com.ebmwebsourcing.easyschema10.api.element.Import impt = (com.ebmwebsourcing.easyschema10.api.element.Import)obj;
						if(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema) {
							Schema imptSchema = (Schema) impt.getXmlObjectAdoptedChildren()[0];
							if(impt.getSchemaLocation().equals(relativePath)) {
								res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
								SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(imptSchema, res);
								break;
							} else {
								imptSchemas.add(imptSchema);
							}
						}
					} else if(obj instanceof com.ebmwebsourcing.easyschema10.api.element.Include) {
						com.ebmwebsourcing.easyschema10.api.element.Include impt = (com.ebmwebsourcing.easyschema10.api.element.Include)obj;
						if(impt.getXmlObjectAdoptedChildren()[0] instanceof Schema) {
							Schema imptSchema = (Schema) impt.getXmlObjectAdoptedChildren()[0];
							if(impt.getSchemaLocation().equals(relativePath)) {
								res = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
								SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(imptSchema, res);
								break;
							} else {
								imptSchemas.add(imptSchema);
							}
						}
					}
				}
			}
		}

		if(res == null) {
			for(Definitions imptdef: imptdefs) {
				res = findAllURIInDescription(imptdef, relativePath);
				if(res != null) {
					break;
				}
			}

			if(res == null) {
				for(Schema imptSchema: imptSchemas) {
					res = findImportAndIncludeInSchema(imptSchema, relativePath);
					if(res != null) {
						break;
					}
				}
			}
		}
		return res;
	}
	
}
