/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.registry;

import java.net.URI;
import java.util.List;
import java.util.Map;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.BusinessService;
import com.ebmwebsourcing.easyesb.soa.api.service.TechnicalService;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;

import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryEndpointBehaviourItf;

public interface RegistryEndpointBehaviour extends EndpointBehaviour, RegistryEndpointBehaviourItf {

	public static String DESCRIPTION_URL = "wsdl/registryEndpointBehaviour.wsdl";
	
	EndpointType getEndpoint(URI name) throws ESBException;
		
	Endpoint<? extends EndpointType> getLocalEndpoint(URI value) throws ESBException;
	
	List<Endpoint<? extends EndpointType>> getLocalEndpoints();
	
	Endpoint<? extends EndpointType> removeLocalEndpoint(Endpoint<? extends EndpointType> ep) throws ESBException;
	
	Map<URI, EndpointType> getRemoteEndpoints();
	
	List<TechnicalService<? extends ServiceType>> getTechnicalServices();
	
	List<BusinessService<? extends ServiceType>> getBusinessServices();

	

}
