/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.api.endpoint;

import java.net.URI;
import java.util.List;

import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.EndpointInitializationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.transport.Skeleton;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;


public interface Endpoint<M extends EndpointType> extends SOAElement<M>, SCAComponent, Skeleton {

	void init() throws ESBException;
	
	URI getReference();
	
	Description getDescription();
	
	void setDescription(Description desc);
	
	void refreshDescription() throws ESBException;
	
	Skeleton getSkeleton();
	
	Node<? extends NodeType> getNode();
	
	void setNode(Node<? extends NodeType> node) throws ESBException;
		
	Class<? extends EndpointBehaviour>[] getBehaviourClasses() throws ClassNotFoundException;
	
	void addBehaviourClass(Class<? extends EndpointBehaviour> behaviourClass) throws ESBException;
	
	void removeBehaviourClass(Class<? extends EndpointBehaviour> behaviourClass) throws ESBException;
	
	List<EndpointBehaviour> getBehaviours() throws ESBException;

	<B extends EndpointBehaviour> B findBehaviour(Class<B> behaviour);
	
	ListenersManager getListenersManager();
	
	void setListenersManager(ListenersManager listenerManager);
	
	Class<M> getModelClass();
	
	M getModel();
	
	void addEndpointInitializationInterceptor(EndpointInitializationInterceptor i);
	
	EndpointInitializationInterceptor removeEndpointInitializationInterceptor(EndpointInitializationInterceptor i);
	
	List<EndpointInitializationInterceptor> getEndpointInitializationInterceptors();
	
}
