/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.petalslink.abslayer.service.api.Binding;

public abstract class AbstractEndpointBehaviourImpl
implements EndpointBehaviour {
    private static Logger log = Logger.getLogger(AbstractEndpointBehaviourImpl.class.getName());
    private Binding binding;
    public Endpoint<? extends EndpointType> endpoint;

    public AbstractEndpointBehaviourImpl(Endpoint<? extends EndpointType> ep) {
        this.endpoint = ep;
    }

    @Override
    public Endpoint<? extends EndpointType> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void execute(Exchange exchange) throws TransportException {
        log.finest("operation invoked: " + exchange.getOperation());
        Method m = this.findMethod(exchange.getOperation());
        if (m != null) {
            try {
                m.invoke((Object)this, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new TransportException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new TransportException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new TransportException((Throwable)e);
            }
        }
    }

    protected Method findMethod(String operation) {
        Method res = null;
        for (Method m : EndpointBehaviour.class.getMethods()) {
            if (!m.getName().equals(operation)) continue;
            res = m;
            break;
        }
        return res;
    }

    public String getBehaviourClassName() {
        return this.getClass().getName();
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }
}

