/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa.impl.test.util.EchoBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.element.SenderInitialisation;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.EchoResponse;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ESBTransporterTest {
    private EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);

    public ESBTransporterTest() throws Exception {
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, String host, int port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port);
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronousInOutSend() throws ESBException, TransportException, ParserConfigurationException, InterruptedException, ExchangeException, SOAException {
        boolean explorer = false;
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9001);
        try {
            Service service = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/wheather", "weather"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myWeatherEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/wheather", "myClientWheatherEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            System.out.println("clientEndpoint  = " + clientEndpoint);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            System.out.println("Exchange = " + exchange);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((Object)"Hello world!!!", (Object)businessReponse.getOut());
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testASynchronousInOutSend() throws ESBException, TransportException, ParserConfigurationException, InterruptedException, ExchangeException, SOAException {
        boolean explorer = false;
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9001);
        try {
            Service service = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createService(new QName("http://com.ebmwebsourcing.easyesb/wheather", "weather"), BusinessServiceImpl.class);
            ProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("myWeatherEndpoint", ProviderEndpointImpl.class, EchoBehaviour.class, this.context, new SenderInitialisation[0]);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/wheather", "myClientWheatherEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpoint.getReference());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ws.easyesb.ebmwebsourcing.com/echo/", "echo").toString());
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo);
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(payload);
            clientEndpoint.send(exchange);
            Exchange response = null;
            while (response == null) {
                try {
                    Exchange ex = clientEndpoint.pull(clientEndpoint.getReference(), clientEndpoint.getNode().getQName());
                    if (ex == null || !ex.getUuid().toString().equals(exchange.getUuid().toString())) continue;
                    response = ex;
                }
                catch (TransportException e) {}
            }
            System.out.println("response = " + response.getMessageOut().getBody().getPayload().getDocumentElement().getNodeValue());
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(response.getMessageOut().getBody().getPayload(), EchoResponse.class);
            Assert.assertEquals((Object)"Hello world!!!", (Object)businessReponse.getOut());
        }
        finally {
            node.stop();
        }
    }
}

