/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.net.URI;
import java.util.List;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.transport.Stub;
import com.ebmwebsourcing.easyesb.soa.impl.transport.StubImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

@Scope("COMPOSITE")
@Service(value=ClientEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ClientEndpointImpl<M extends ClientEndpointType> extends AbstractEndpointImpl<M> implements ClientEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Stub stub;
	
	@SuppressWarnings("unchecked")
	public ClientEndpointImpl() {
		super();
		this.stub = new StubImpl((ClientEndpoint)this);
		
	}
	
	@SuppressWarnings("unchecked")
	public ClientEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
		this.stub = new StubImpl((ClientEndpoint)this);
	}

	public void send(Exchange exchange) throws TransportException {
		this.stub.send(exchange);
	}
	
	public Exchange sendSync(Exchange exchange, long timeout) throws TransportException {
		return this.stub.sendSync(exchange, timeout);
	}
	
	public Stub getStub() {
		return this.stub;
	}

	public void setStub(Stub stub) {
		this.stub = stub;
	}

	public Exchange createExchange() throws ExchangeException {
		return this.stub.createExchange();
	}

	public Description getDescriptionOfProviderEndpoint(QName name)
			throws ESBException {
		return this.stub.getDescriptionOfProviderEndpoint(name);
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ClientEndpointType.class;
		}
		return res;
	}

	public void addClientEndpointInvocationInterceptor(
			ClientEndpointInvocationInterceptor i) {
		this.stub.addClientEndpointInvocationInterceptor(i);
	}

	public ClientEndpointInvocationInterceptor removeClientEndpointInvocationInterceptor(
			ClientEndpointInvocationInterceptor i) {
		return this.stub.removeClientEndpointInvocationInterceptor(i);
	}

	public List<ClientEndpointInvocationInterceptor> getClientEndpointInvocationInterceptor() {
		return this.stub.getClientEndpointInvocationInterceptor();
	}

	public void addProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		this.getSkeleton().addProviderEndpointInvocationInterceptor(i);
	}

	public ProviderEndpointInvocationInterceptor removeProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		return this.getSkeleton().removeProviderEndpointInvocationInterceptor(i);
	}

	public List<ProviderEndpointInvocationInterceptor> getProviderEndpointInvocationInterceptor() {
		return this.getProviderEndpointInvocationInterceptor();
	}

	public Exchange pull(QName providerEndpointName, QName nodeEndpointName)
			throws TransportException {
		return this.stub.pull(providerEndpointName, nodeEndpointName);
	}

	@Override
	public URI getEndpointReference() {
		return URI.create("esb://" + this.getQName().getNamespaceURI() + "@" + this.getQName().getLocalPart());
	}

}
