/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform
 * Copyright (C) 2005 EBM WebSourcing
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 *
 * Initial developer(s): pierre.garcia@inrialpes.fr
 *
 */

package com.ebmwebsourcing.easyesb.soa.impl.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAContentController;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ClassUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAComponentImpl;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.exchange10.api.util.Util;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.WakeUpKey;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.Constants;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportContext;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.api.transport.Transporter;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransporterImpl;

/**
 * @author Nicolas Salatge
 */
@Scope("COMPOSITE")
@Service(value=TransportersManager.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class TransportersManagerImpl extends SCAComponentImpl implements TransportersManager {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    //	private static Logger log = Logger.getLogger(TransportersManagerImpl.class.getName());

    private QName name;

    private List<Component> transporters = new ArrayList<Component>(); 

    private Map<UUID, WakeUpKey> stub2awake = new HashMap<UUID, WakeUpKey>();

    @SuppressWarnings("unchecked")
    private Node node = null;


    public TransportersManagerImpl() {

    }


    @SuppressWarnings("unchecked")
    public <T extends Transporter>  T  createTransporter(String name, Class<T> clazz) throws ESBException {
        T transporter = null;
        try {
            org.objectweb.fractal.api.Component transporterComponent = SCAHelper.getSCAHelper().createNewComponent(clazz.getName(), null);
            SCAHelper.getSCAHelper().startComponent(transporterComponent);

            if(name != null) {
                SCAHelper.getSCAHelper().changeName(transporterComponent, name.toString());
            }

            transporter = (T)transporterComponent.getFcInterface("service");

            // init
            //	transporter.initFractalComponent(transporterComponent);

            // add component in list
            SCAHelper.getSCAHelper().addComponent(transporterComponent, this.getComponent(), null);
            this.transporters.add(transporterComponent);


        } catch (NoSuchInterfaceException e) {
            throw new ESBException(e);
        } catch (SCAException e) {
            throw new ESBException(e);
        }
        //	log.fine("transporter " + name + " created and started");
        return transporter;
    }

    /**
     * Utility to get the matching Transport Protocol component
     * 
     * @param destinationEndpointName
     *            The name of the Transport Protocol
     */
    private Transporter findTransporter() throws TransportException {
        Transporter protocol = null; 
        try {
            if(this.transporters == null || this.transporters.size() == 0) {
                throw new TransportException("Impossible to find transporter");
            }
            protocol = (Transporter) ((SCAContentController)this.transporters.get(0).getFcInterface(SCAContentController.NAME)).getFcContent();
        } catch (NoSuchInterfaceException e) {
            throw new TransportException(e);
        } catch (ContentInstantiationException e) {
            throw new TransportException(e);
        }

        return protocol;
    }

    public void setQName(QName name) {
        this.name = name;
    }

    public QName getQName() {
        return this.name;
    }

    public synchronized Exchange pull(QName providerEndpointName, QName nodeEndpointName) throws TransportException {
        Exchange res = null;
        Transporter protocol = null; 

        if(providerEndpointName == null) {
            throw new TransportException("provider name cannot be null");
        }
        if(nodeEndpointName == null) {
            throw new TransportException("node name cannot be null");
        }
        //	log.finest("PULL ON: " + providerEndpointName + " - node = " + nodeEndpointName);


        protocol = findTransporter();
        res = protocol.pull(providerEndpointName, nodeEndpointName);

        return res;
    }

    //	public synchronized Exchange pull(UUID uuid, QName providerEndpointName, QName nodeEndpointName) throws TransportException {
    //		Exchange res = null;
    //		Transporter protocol = null; 
    //
    //		log.finest("PULL WITH UUID ON: " + providerEndpointName + " - node = " + nodeEndpointName + "with uuid = " + uuid);
    //
    //		if(uuid == null) {
    //			throw new TransportException("uuid cannot be null");
    //		}
    //		if(providerEndpointName == null) {
    //			throw new TransportException("provider name cannot be null");
    //		}
    //		if(nodeEndpointName == null) {
    //			throw new TransportException("node name cannot be null");
    //		}
    //
    //		protocol = findTransporter();
    //		res = protocol.pull(uuid, providerEndpointName, nodeEndpointName);
    //
    //		return res;
    //	}

    @SuppressWarnings("unchecked")
    public void push(Exchange exchange, QName destinationNodeName) throws TransportException {
        //log.finest("exchange " + exchange.getUuid() + " send to endpoint "
        //		+ exchange.getDestination() + " on node " + destinationNodeName);
        if(destinationNodeName == null) {
            throw new TransportException("destination name cannot be null");
        }
        if(exchange == null) {
            throw new TransportException("exchange cannot be null");
        }

        QName destination = exchange.getDestination();
        if(exchange.getStatus().equals(StatusType.DONE) || exchange.getStatus().equals(StatusType.FAULT)) {
            destination = exchange.getSource();
        }
        //	log.finest("PUSH TO: " + destination + " - node: " + destinationNodeName);


        Transporter protocol = this.findTransporter();

        // find node of endpoint in property of exchange
        SourceNodeInformations sourceNodeInfos = null;
        Document sourceNodeDoc = null;
        if(exchange.getMessageIn().getHeader() != null) {
            sourceNodeDoc = exchange.getMessageIn().getHeader().getProperty(new QName(Constants.SOA_DATAMODEL_NS_URI, "sourceNodeInformations"));
        }
        if(sourceNodeDoc != null) {
            try {
                sourceNodeInfos = SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readFragment(Util.convertDocumentToInputStream(sourceNodeDoc), SourceNodeInformations.class);
            } catch (XmlObjectValidationException e) {
                throw new TransportException(e);
            } catch (XmlObjectReadException e) {
                throw new TransportException(e);
            }
        }




        if(protocol instanceof SOAPTransporterImpl && sourceNodeInfos != null) {
            ((SOAPTransporterImpl)protocol).getListOfTransporters().put(sourceNodeInfos.getNodeName(), MessageUtil.getInstance().getSOAPTransporterAddress(sourceNodeInfos.getHost(), sourceNodeInfos.getPort()));
        }
        protocol.push(exchange, destinationNodeName);
    }

    public Map<UUID, WakeUpKey> getStub2awake() {
        return stub2awake;
    }

    public TransportContext getContext() {
        return null;
    }


    public void setContext(TransportContext arg0) {
        throw new UnsupportedOperationException();
    }

    public void stop() throws TransportException {
        try {
            for(Component transporter: this.transporters) {
                Transporter protocol = (Transporter) transporter.getFcInterface("service");
                protocol.stop();
            }
        } catch (NoSuchInterfaceException e) {
            throw new TransportException(e);
        }
    }

    public void start() throws TransportException {
        try {
            for(Component transporter: this.transporters) {
                Transporter protocol = (Transporter) transporter.getFcInterface("service");
                protocol.start();
            }
        } catch (NoSuchInterfaceException e) {
            throw new TransportException(e);
        }
    }


    public boolean isStopped(){
        boolean res = false;

        try {
            for(Component c : this.transporters){
                if(!((Transporter)c.getFcInterface("service")).isStopped()) return false;
            }
            res = true;
        } catch (NoSuchInterfaceException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            res = false;
        }
        return res;
    }



    @SuppressWarnings("unchecked")
    public <T extends Transporter>  T  getTransporter(Class<T> clazz) {
        T transporter = null;
        try {
            for(Component transporterC: this.transporters) {
                Transporter protocol = (Transporter) ((SCAContentController)transporterC.getFcInterface(SCAContentController.NAME)).getFcContent();
                if(ClassUtil.isClassExtendOfClass2found(protocol.getClass(), clazz)) {
                    transporter = (T) protocol;
                    break;
                }
            }
        } catch (NoSuchInterfaceException e) {
            // do nothing
            e.printStackTrace();
        } catch (ContentInstantiationException e) {
            // do nothing
            e.printStackTrace();
        }
        //	log.fine("transporter " + name + " found");
        return transporter;
    }

    @SuppressWarnings("unchecked")
    public Node getNode() {
        return this.node;
    }

    @SuppressWarnings("unchecked")
    public void setNode(Node node) {
        this.node = node;
    }

}
