/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver;

import com.ebmwebsourcing.easycommons.uri.URIHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

public class EasyESBInternalURIResolver
implements URIResolver {
    private List<URI> importedURI = Collections.synchronizedList(new ArrayList());

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        URI systemId;
        SAXSource s = null;
        if (base == null && !(systemId = URI.create(href)).isAbsolute() && !"jar".equals(systemId.getScheme())) {
            ArrayList<URI> newImportedURIs = new ArrayList<URI>();
            for (URI potentialBaseUri : this.importedURI) {
                try {
                    URI newURI = URIHelper.resolve((URI)potentialBaseUri, (String)href);
                    newImportedURIs.add(newURI);
                    s = new SAXSource(new InputSource(newURI.toURL().openStream()));
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (s != null) break;
            }
            for (URI uri : newImportedURIs) {
                this.addImportedURI(uri);
            }
            if (s == null) {
                URL newUrl = Thread.currentThread().getContextClassLoader().getResource(href);
                try {
                    s = new SAXSource(new InputSource(newUrl.openStream()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    public void addImportedURI(URI uri) {
        if (!this.importedURI.contains(uri)) {
            this.importedURI.add(uri);
        }
    }
}

