/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.TechnicalEndpointInfosBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.ImportUtil;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetBehaviourClassNames;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetBehaviourClassNamesResponse;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetDescription;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetDescriptionResponse;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetEndpointQNameResponse;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetNodeQNameResponse;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetResources;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetResourcesFault;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetResourcesFault_Exception;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.GetResourcesResponse;
import easyesb.ebmwebsourcing.com.soa.model.endpoint.PingResponse;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class TechnicalEndpointInfosBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements TechnicalEndpointInfosBehaviour {
    private static Logger log = Logger.getLogger(TechnicalEndpointInfosBehaviourImpl.class.getName());
    private static Binding b;

    static {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/technical/behaviour/technicalEndpointInfosBehaviour.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(url, Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public TechnicalEndpointInfosBehaviourImpl(Endpoint<? extends EndpointType> ep) {
        super(ep);
        this.setBinding(b);
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            log.finest("Technical Endpoint Infos BEHAVIOUR FOUND: " + exchange.getOperation());
            log.finest("Technical Endpoint Infos BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().printMessage()));
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getEndpointQName") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("getEndpointQName");
                GetEndpointQNameResponse response = new GetEndpointQNameResponse();
                response.setName(this.getEndpointQName());
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getBehaviourClassName") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("getBehaviourClassName");
                GetBehaviourClassNames request = (GetBehaviourClassNames)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetBehaviourClassNames.class);
                GetBehaviourClassNamesResponse response = this.getBehaviourClassName(request);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getNodeQName") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("getNodeQName");
                GetNodeQNameResponse response = new GetNodeQNameResponse();
                response.setName(this.getNodeQName());
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getDescription") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("getDescription");
                GetDescription request = (GetDescription)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetDescription.class);
                GetDescriptionResponse response = this.getDescription(request);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("ping") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("ping");
                PingResponse response = new PingResponse();
                response.setOut(this.ping());
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getResources") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.ebmwebsourcing.easyesb/soa/model/endpoint")) {
                log.finest("getResources");
                GetResources request = (GetResources)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetResources.class);
                GetResourcesResponse response = this.getResources(request);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            }
        }
        catch (SOAException e) {
            log.severe("ESB Exception: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (GetResourcesFault_Exception e) {
            log.severe("ESB Exception: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
    }

    public GetBehaviourClassNamesResponse getBehaviourClassName(GetBehaviourClassNames parameters) {
        GetBehaviourClassNamesResponse response = new GetBehaviourClassNamesResponse();
        response.getClassName().addAll((Collection)Arrays.asList(this.getEndpoint().getModel().getBehavioursList().getBehaviours()));
        return response;
    }

    public String ping() {
        return "endpoint: " + this.getEndpointQName() + " on node " + this.getNodeQName() + " => I'm alive!!!";
    }

    public GetDescriptionResponse getDescription(GetDescription getDescriptionRequest) {
        GetDescriptionResponse response = new GetDescriptionResponse();
        try {
            response.setAny((Object)this.getEndpoint().getDescription().write().getDocumentElement());
        }
        catch (XmlObjectWriteException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public GetResourcesResponse getResources(GetResources getResourcesRequest) throws GetResourcesFault_Exception {
        GetResourcesResponse res = new GetResourcesResponse();
        String relativePath = getResourcesRequest.getRelativePath();
        try {
            Document doc = ImportUtil.getInstance().findImportInDescription(this.getEndpoint().getDescription(), relativePath);
            if (doc == null) {
                GetResourcesFault fault = new GetResourcesFault();
                String msg = "Impossible to find description corresponding to " + relativePath;
                fault.setMessage(msg);
                throw new GetResourcesFault_Exception(msg, fault);
            }
            res.setAny((Object)doc.getDocumentElement());
        }
        catch (XmlObjectWriteException e) {
            e.printStackTrace();
            GetResourcesFault fault = new GetResourcesFault();
            fault.setMessage(e.getMessage());
            fault.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            throw new GetResourcesFault_Exception(e.getMessage(), fault);
        }
        return res;
    }
}

