/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.config;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationImpl
implements Configuration {
    private static Logger log = Logger.getLogger(ConfigurationImpl.class.getName());
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static String CONFIG = "config.properties";
    private List<ExternalServer> externalServers = new ArrayList<ExternalServer>();
    private List<String> endpointInitializationInterceptors = new ArrayList<String>();
    private Class<? extends RegistryService> registryServiceClass;
    private Class<? extends RegistryServiceBehaviour> registryServiceBehaviourClass;
    private Class<? extends Service> adminServiceClass;
    private Class<? extends ServiceBehaviour> adminServiceBehaviourClass;
    private Class<? extends EndpointBehaviour> adminEndpointBehaviourClass;
    private Class<? extends Service> resourcesServiceClass;
    private Class<? extends ServiceBehaviour> resourcesServiceBehaviourClass;
    private Class<? extends EndpointBehaviour> resourcesEndpointBehaviourClass;

    public ConfigurationImpl() throws ESBException {
        this.properties.put("explorer", "false");
        this.properties.put("host", "localhost");
        this.properties.put("port", "9000");
        this.loadConfigurationFile();
    }

    public ConfigurationImpl(Map<String, String> data) throws ESBException {
        this.properties = data;
    }

    public ConfigurationImpl(boolean explorer, String host, int port, ExternalServer ... servers) throws ESBException {
        this.properties.put("explorer", String.valueOf(explorer));
        this.properties.put("host", String.valueOf(host));
        this.properties.put("port", String.valueOf(port));
        ExternalServer[] externalServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalServer server = externalServerArray[n2];
            this.externalServers.add(server);
            ++n2;
        }
    }

    private void loadConfigurationFile() throws ESBException {
        Properties props = new Properties();
        File f = new File(CONFIG);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading config from " + f.getAbsoluteFile());
        }
        FileInputStream is = null;
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new ESBException((Throwable)e);
            }
        }
        if (is != null) {
            try {
                props.load(is);
                for (Object k : props.keySet()) {
                    if ("common-endpoint-initialization-interceptor".equals(k.toString().trim())) {
                        String interceptorClassName = props.get(k).toString().trim();
                        this.endpointInitializationInterceptors.add(interceptorClassName);
                        continue;
                    }
                    if ("registry-service-class".equals(k.toString().trim())) {
                        String registryServiceClassName = props.get(k).toString().trim();
                        Class<?> registryServiceClass = Thread.currentThread().getContextClassLoader().loadClass(registryServiceClassName);
                        this.setRegistryServiceClass(registryServiceClass);
                        continue;
                    }
                    if ("registry-service-behaviour-class".equals(k.toString().trim())) {
                        String registryServiceBehaviourClassName = props.get(k).toString().trim();
                        Class<?> registryServiceBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(registryServiceBehaviourClassName);
                        this.setRegistryServiceBehaviourClass(registryServiceBehaviourClass);
                        continue;
                    }
                    if ("admin-service-class".equals(k.toString().trim())) {
                        String registryAdminClassName = props.get(k).toString().trim();
                        Class<?> registryAdminClass = Thread.currentThread().getContextClassLoader().loadClass(registryAdminClassName);
                        this.setAdminServiceClass(registryAdminClass);
                        continue;
                    }
                    if ("admin-service-behaviour-class".equals(k.toString().trim())) {
                        String adminServiceBehaviourClassName = props.get(k).toString().trim();
                        Class<?> adminServiceBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(adminServiceBehaviourClassName);
                        this.setAdminServiceBehaviourClass(adminServiceBehaviourClass);
                        continue;
                    }
                    if ("admin-endpoint-behaviour-class".equals(k.toString().trim())) {
                        String adminEndpointBehaviourClassName = props.get(k).toString().trim();
                        Class<?> adminEndpointBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(adminEndpointBehaviourClassName);
                        this.setAdminEndpointBehaviourClass(adminEndpointBehaviourClass);
                        continue;
                    }
                    if ("resources-service-class".equals(k.toString().trim())) {
                        String registryResourcesClassName = props.get(k).toString().trim();
                        Class<?> registryResourcesClass = Thread.currentThread().getContextClassLoader().loadClass(registryResourcesClassName);
                        this.setResourcesServiceClass(registryResourcesClass);
                        continue;
                    }
                    if ("resources-service-behaviour-class".equals(k.toString().trim())) {
                        String resourcesServiceBehaviourClassName = props.get(k).toString().trim();
                        Class<?> resourcesServiceBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(resourcesServiceBehaviourClassName);
                        this.setResourcesServiceBehaviourClass(resourcesServiceBehaviourClass);
                        continue;
                    }
                    if ("resources-endpoint-behaviour-class".equals(k.toString().trim())) {
                        String resourcesEndpointBehaviourClassName = props.get(k).toString().trim();
                        Class<?> resourcesEndpointBehaviourClass = Thread.currentThread().getContextClassLoader().loadClass(resourcesEndpointBehaviourClassName);
                        this.setResourcesEndpointBehaviourClass(resourcesEndpointBehaviourClass);
                        continue;
                    }
                    this.properties.put(k.toString().trim(), props.get(k).toString().trim());
                }
            }
            catch (IOException e) {
                throw new ESBException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new ESBException((Throwable)e);
            }
        } else {
            log.warning("No configuration file found...");
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public static String getCONFIG() {
        return CONFIG;
    }

    public static void setCONFIG(String config) {
        CONFIG = config;
    }

    public Integer getPort() {
        return Integer.valueOf(this.getProperties().get("port"));
    }

    public Boolean getExplorer() {
        return Boolean.valueOf(this.getProperties().get("explorer"));
    }

    public String getHost() {
        return String.valueOf(this.getProperties().get("host"));
    }

    public void setExplorer(boolean explorer) {
        this.properties.put("explorer", String.valueOf(explorer));
    }

    public void setHost(String host) {
        this.properties.put("host", String.valueOf(host));
    }

    public void setPort(int port) {
        this.properties.put("port", String.valueOf(port));
    }

    public List<ExternalServer> getExternalServers() {
        return this.externalServers;
    }

    public void addExternalServer(ExternalServer es) {
        this.externalServers.add(es);
    }

    public List<String> getEndpointInitializationInterceptorClassNames() {
        return this.endpointInitializationInterceptors;
    }

    public void addEndpointInitializationInterceptorClassName(String eii) {
        this.endpointInitializationInterceptors.add(eii);
    }

    public Class<? extends RegistryService> getRegistryServiceClass() {
        return this.registryServiceClass;
    }

    public void setRegistryServiceClass(Class<? extends RegistryService> clazz) {
        this.registryServiceClass = clazz;
    }

    public Class<? extends RegistryServiceBehaviour> getRegistryServiceBehaviourClass() {
        return this.registryServiceBehaviourClass;
    }

    public void setRegistryServiceBehaviourClass(Class<? extends RegistryServiceBehaviour> clazz) {
        this.registryServiceBehaviourClass = clazz;
    }

    public Class<? extends Service> getAdminServiceClass() {
        return this.adminServiceClass;
    }

    public void setAdminServiceClass(Class<? extends Service> clazz) {
        this.adminServiceClass = clazz;
    }

    public Class<? extends ServiceBehaviour> getAdminServiceBehaviourClass() {
        return this.adminServiceBehaviourClass;
    }

    public void setAdminServiceBehaviourClass(Class<? extends ServiceBehaviour> clazz) {
        this.adminServiceBehaviourClass = clazz;
    }

    public Class<? extends EndpointBehaviour> getAdminEndpointBehaviourClass() {
        return this.adminEndpointBehaviourClass;
    }

    public void setAdminEndpointBehaviourClass(Class<? extends EndpointBehaviour> clazz) {
        this.adminEndpointBehaviourClass = clazz;
    }

    public Class<? extends Service> getResourcesServiceClass() {
        return this.resourcesServiceClass;
    }

    public void setResourcesServiceClass(Class<? extends Service> clazz) {
        this.resourcesServiceClass = clazz;
    }

    public Class<? extends ServiceBehaviour> getResourcesServiceBehaviourClass() {
        return this.resourcesServiceBehaviourClass;
    }

    public void setResourcesServiceBehaviourClass(Class<? extends ServiceBehaviour> clazz) {
        this.resourcesServiceBehaviourClass = clazz;
    }

    public Class<? extends EndpointBehaviour> getResourcesEndpointBehaviourClass() {
        return this.resourcesEndpointBehaviourClass;
    }

    public void setResourcesEndpointBehaviourClass(Class<? extends EndpointBehaviour> clazz) {
        this.resourcesEndpointBehaviourClass = clazz;
    }
}

