/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.Stub;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.WakeUpKey;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.element.SourceNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;


public class StubImpl implements Stub {

	private static Logger log = Logger.getLogger(StubImpl.class.getName());

	@SuppressWarnings("unchecked")
	private ClientEndpoint clientEndpoint;

	private WakeUpKey locked = new WakeUpKeyImpl();


	private List<ClientEndpointInvocationInterceptor> invocationInterceptors = new ArrayList<ClientEndpointInvocationInterceptor>();


	@SuppressWarnings("unchecked")
	public StubImpl(ClientEndpoint consumerEndpoint) {
		this.clientEndpoint = consumerEndpoint;
	}

	public TransportersManager getTransportersManager() throws ESBException {
		return this.clientEndpoint.getNode().getTransportersManager();
	}

	public Exchange createExchange() throws ExchangeException {
		Exchange res = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Exchange.class);
		res.setUuid(UUID.randomUUID().toString());
		res.setRole(RoleType.CONSUMER);
		res.setStatus(StatusType.ACTIVE);
		res.setSource(clientEndpoint.getQName());
		return res;
	}

	public void send(Exchange exchange) throws TransportException {
		log.finest("exchange sent to " + exchange.getDestination() + ":\n" + exchange);

		// realize pre-processing before sending message
		for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
			ceii.processingExchangeBeforeSending(exchange);
		}

		// find destination node
		EndpointType destination = null;
		RegistryService<?> registryService = ((NodeBehaviour)this.clientEndpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();

		if(registryService != null) {
			try {
				destination = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(exchange.getDestination());
			} catch (ESBException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			}
			if(destination == null) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination());
			}
		} else {
			try {
				destination = ((Endpoint<?>) SCAHelper.getSCAHelper().getFirstComponentByName(this.clientEndpoint.getNode().getComponent(), exchange.getDestination().toString()).getFcInterface("service")).getModel();
			} catch (SCAException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			} catch (NoSuchInterfaceException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			}
			if(destination == null) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination());
			}
		}


		// set service name
		if(destination instanceof ProviderEndpointType) {
			exchange.setServiceName(((ProviderEndpointType)destination).getService());
		}

		// verify operation
		String operationName = exchange.getOperation();
		if(operationName == null) {
			throw new TransportException("Impossible to send message without operation");
		}
		try {
			QName.valueOf(operationName);
		} catch(IllegalArgumentException e) {
			throw new TransportException("The operation name must be a qname!!!");
		}

		try {
			// add source node informations in header of request
			SourceNodeInformations sourceNodeInfos = this.clientEndpoint.getNode().getModel().getBasicNodeInformations().duplicateXmlObjectAs(SourceNodeInformations.class);
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(sourceNodeInfos, baos);
			ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);

			//Document doc = this.clientEndpoint.getNode().getBasicNodeInformations().unmarshall(new QName("http://com.ebmwebsourcing.easyesb/soa/model/datatype", "sourceNode"), this.clientEndpoint.getNode().getBasicNodeInformations());

			if(exchange.getMessageIn().getHeader() == null) {
				Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
				exchange.getMessageIn().setHeader(header);
			}
			exchange.getMessageIn().getHeader().addProperty(doc);


			this.getTransportersManager().push(exchange, destination.getNode());
			baos.close();
		} catch (ESBException e) {
			throw new TransportException(e);
		} catch (SAXException e) {
			throw new TransportException(e);
		} catch (IOException e) {
			throw new TransportException(e);
		} catch (ParserConfigurationException e) {
			throw new TransportException(e);
		} catch (XmlObjectWriteException e) {
			throw new TransportException(e);
		}

		// realize pre-processing after sending message
		for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
			ceii.processingExchangeAfterReceiving(exchange);
		}
	}

	public Exchange sendSync(Exchange exchange, long timeout) throws TransportException {
		log.finest("exchange sent to " + exchange.getDestination() + ":\n" + exchange);

		// realize pre-processing before sending message (t1)
		for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
			ceii.processingExchangeBeforeSending(exchange);
		}

		// realize pre-processing before receiving message
		//		for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
		//			ceii.preProcessingExchangeBeforeReceiving(exchange);
		//		}

		Exchange res = null; 

		// find destination node
		EndpointType destination = null;
		RegistryService<?> registryService = ((NodeBehaviour)this.clientEndpoint.getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();

		if(exchange.getDestination().equals(this.clientEndpoint.getNode().getQName())) {
			destination = (EndpointType) this.clientEndpoint.getNode().getModel();
		} else if(registryService != null) {
			try {
				destination = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)registryService.findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(exchange.getDestination());
			} catch (ESBException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			}
			if(destination == null) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination());
			}
		} else {
			try {
				destination = ((Endpoint<?>) SCAHelper.getSCAHelper().getFirstComponentByName(this.clientEndpoint.getNode().getComponent(), exchange.getDestination().toString()).getFcInterface("service")).getModel();
			} catch (SCAException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			} catch (NoSuchInterfaceException e) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination(), e);
			}
			if(destination == null) {
				throw new TransportException("Impossible to find node having this endpoint: " + exchange.getDestination());
			}
		}

		// set service name
		if(destination instanceof ProviderEndpointType) {
			exchange.setServiceName(((ProviderEndpointType)destination).getService());
		}

		// verify operation
		String operationName = exchange.getOperation();
		if(operationName == null) {
			throw new TransportException("Impossible to send message without operation");
		}
		try {
			QName.valueOf(operationName);
		} catch(IllegalArgumentException e) {
			throw new TransportException("The operation name must be a qname!!!");
		}

		// add source node informations in header of request
		Document sourceNode = null;
		try {
			SourceNodeInformations sourceNodeInfos = this.clientEndpoint.getNode().getModel().getBasicNodeInformations().duplicateXmlObjectAs(SourceNodeInformations.class);
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			SOAUtil.getInstance().getWriter(EasyESBFramework.getInstance()).get().writeDocument(sourceNodeInfos, baos);
			ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
			sourceNode = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);
			writtenStream.close();
			//sourceNode = this.clientEndpoint.getNode().getBasicNodeInformations().unmarshall(new QName("http://com.ebmwebsourcing.easyesb/soa/model/datatype", "sourceNode"), this.clientEndpoint.getNode().getBasicNodeInformations());
		} catch (SAXException e) {
			throw new TransportException(e);
		} catch (IOException e) {
			throw new TransportException(e);
		} catch (ParserConfigurationException e) {
			throw new TransportException(e);
		} catch (XmlObjectWriteException e) {
			throw new TransportException(e);
		}
		if(exchange.getMessageIn().getHeader() == null) {
			Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
			exchange.getMessageIn().setHeader(header);
		}
		exchange.getMessageIn().getHeader().addProperty(sourceNode);


		this.locked.setExchange(null);

		TransportersManager transporter = null;
		try {
			transporter = this.getTransportersManager();
		} catch(ESBException e) {
			throw new TransportException(e);
		}

		if(transporter != null) {
			try {
				this.getTransportersManager().getStub2awake().put(UUID.fromString(exchange.getUuid()), this.locked);
			} catch (ESBException e) {
				throw new TransportException(e);
			}


			try {

				synchronized(this.locked) {

					this.getTransportersManager().push(exchange, destination.getNode());

					this.locked.wait(timeout);
				}

				res = this.locked.getExchange();

				if(res == null) {
					throw new TransportException("Timeout exceeded!!!!");
				}

				// add new property in first exchange
				for(Document doc: res.getMessageIn().getHeader().getProperties()) {
					QName propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
					if(exchange.getMessageIn().getHeader().getProperty(propertyQName) == null) {
						exchange.getMessageIn().getHeader().addProperty(doc);
					} else {
						exchange.getMessageIn().getHeader().removeProperty(propertyQName);
						exchange.getMessageIn().getHeader().addProperty(doc);
					}
				}
				// copy out in first exchange
				if(res.getMessageOut() != null && res.getMessageOut().getHeader() != null) {
					MessageUtil.getInstance().createOutMessageStructure(exchange);
					if(exchange.getMessageOut().getHeader() == null) {
						Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
						exchange.getMessageOut().setHeader(header);
					}
					for(Document doc: res.getMessageOut().getHeader().getProperties()) {
						QName propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
						if(exchange.getMessageOut().getHeader().getProperty(propertyQName) == null) {
							exchange.getMessageOut().getHeader().addProperty(doc);
						} else {
							exchange.getMessageOut().getHeader().removeProperty(propertyQName);
							exchange.getMessageOut().getHeader().addProperty(doc);
						}
					}
				}

				if(res.getMessageOut() != null && res.getMessageOut().getBody() != null) {
					MessageUtil.getInstance().createOutMessageStructure(exchange);
					exchange.getMessageOut().getBody().setPayload(res.getMessageOut().getBody().getPayload());
				}

				if(res.getMessageError() != null && res.getMessageError().getHeader() != null) {
					MessageUtil.getInstance().createErrorMessageStructure(exchange);
					if(exchange.getMessageError().getHeader() == null) {
						Header header = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Header.class);
						exchange.getMessageError().setHeader(header);
					}
					for(Document doc: res.getMessageError().getHeader().getProperties()) {
						QName propertyQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
						if(exchange.getMessageError().getHeader().getProperty(propertyQName) == null) {
							exchange.getMessageError().getHeader().addProperty(doc);
						} else {
							exchange.getMessageError().getHeader().removeProperty(propertyQName);
							exchange.getMessageError().getHeader().addProperty(doc);
						}
					}
				}

				if(res.getMessageError() != null && res.getMessageError().getBody() != null) {
					MessageUtil.getInstance().createErrorMessageStructure(exchange);
					exchange.getMessageError().getBody().setPayload(res.getMessageError().getBody().getPayload());
				}

				exchange.setStatus(res.getStatus());
				exchange.setRole(res.getRole());

				res = exchange;

			} catch (InterruptedException e) {
				throw new TransportException(e);
			} catch (ESBException e) {
				throw new TransportException(e);
			}

			// realize post-processing after sending message
			//		for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
			//			ceii.postProcessingExchangeAfterSending(exchange);
			//		}
			// realize post-processing after receiving message (t4)
			for(ClientEndpointInvocationInterceptor ceii: this.invocationInterceptors) {
				ceii.processingExchangeAfterReceiving(exchange);
			}
		}
		return res;
	}



	public Description getDescriptionOfProviderEndpoint(QName providerName) throws ESBException {
		Description desc = null;
		try {

			// find if provider is on the same node
			Endpoint provider = ((RegistryEndpointBehaviour)this.clientEndpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(providerName);
			if(provider != null) {
				desc = provider.getDescription();
			} else {
				// find provider on remote node
				Exchange exchange = this.createExchange();
				exchange.setSource(this.clientEndpoint.getQName());
				exchange.setDestination(providerName);
				exchange.setOperation(new QName("com.ebmwebsourcing.easyesb", "description").toString());
				exchange.setPattern(PatternType.IN_OUT);
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.createElement("wsdlDescription");

				MessageUtil.getInstance().createInMessageStructure(exchange);
				exchange.getMessageIn().getBody().setPayload(doc);

				try {
					Exchange response = this.sendSync(exchange, 0);
					assert response != null;

					if(!response.hasMessageError()){

						desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(response.getMessageOut().getBody().getPayload(), Definitions.class));
					}
				} catch (TransportException e) {
					// do nothing
					log.warning(e.getMessage());
				} 

				
			}
		} catch (ParserConfigurationException e) {
			throw new ESBException(e);
		} catch (ExchangeException e) {
			throw new ESBException(e);
		} catch (XmlObjectReadException e) {
			throw new ESBException(e);
		} 
		return desc;
	}


	public void addClientEndpointInvocationInterceptor(
			ClientEndpointInvocationInterceptor i) {
		this.invocationInterceptors.add(i);
	}

	public ClientEndpointInvocationInterceptor removeClientEndpointInvocationInterceptor(
			ClientEndpointInvocationInterceptor i) {
		return (this.invocationInterceptors.remove(i) ? i: null);
	}

	public List<ClientEndpointInvocationInterceptor> getClientEndpointInvocationInterceptor() {
		return this.invocationInterceptors;
	}

	public Exchange pull(QName providerEndpointName, QName nodeEndpointName)
			throws TransportException {
		Exchange res = null;
		try {
			res = this.getTransportersManager().pull(providerEndpointName, nodeEndpointName);
		} catch (ESBException e) {
			throw new TransportException(e);
		}

		if(res != null) {

			// Change role
			if(res.getRole() == RoleType.CONSUMER) {
				res.setRole(RoleType.PROVIDER);
			} else {
				res.setRole(RoleType.CONSUMER);
			}
		}
		return res;
	}

}
