/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.ESBKernelFactory;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ESBKernelFactoryImpl
implements ESBKernelFactory {
    private static Logger log = Logger.getLogger(ESBKernelFactoryImpl.class.getName());

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.endpoint.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.service.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.component.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.node.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public Node createNode(QName name, Configuration config) throws ESBException {
        Node node = null;
        try {
            XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory();
            com.ebmwebsourcing.easyesb.soa10.api.element.Node model = (com.ebmwebsourcing.easyesb.soa10.api.element.Node)factory.create(com.ebmwebsourcing.easyesb.soa10.api.element.Node.class);
            model.setName(name);
            model.setBehavioursList((BehavioursList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
            model.getBehavioursList().addBehaviour(NodeBehaviourImpl.class.getName());
            HashMap<String, com.ebmwebsourcing.easyesb.soa10.api.element.Node> context = new HashMap<String, com.ebmwebsourcing.easyesb.soa10.api.element.Node>();
            context.put("model", model);
            Component nodeComponent = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), context);
            SCAHelper.getSCAHelper().startComponent(nodeComponent);
            if (name != null) {
                SCAHelper.getSCAHelper().changeName(nodeComponent, name.toString());
            }
            node = (Node)nodeComponent.getFcInterface("service");
            node.init();
            ((com.ebmwebsourcing.easyesb.soa10.api.element.Node)node.getModel()).setClientEndpointsGroupList((ClientEndpointsGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ClientEndpointsGroupList.class));
            node.setNode(node);
            node.getModel().setEndpointInitialContext((EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));
            ((NodeType)node.getModel()).setServicesGroupList((ServicesGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ServicesGroupList.class));
            ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).setConfiguration(config);
            if (config.getRegistryServiceClass() == null) {
                log.warning("No Registry Service defined. Distributed communication is not possible!!!!");
            } else {
                EndpointInitialContext initialEndpointContext = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
                initialEndpointContext.setNumberOfThreads(5);
                RegistryService registryService = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createRegistryService(String.valueOf(name.getLocalPart()) + "_registry", config.getRegistryServiceClass(), config.getRegistryServiceBehaviourClass(), initialEndpointContext);
            }
            TransportersManager transportersManager = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createTransportersManager(String.valueOf(name.getLocalPart()) + "_transporterManager");
            transportersManager.setNode(node);
            if (node.getModel().getEndpointInitialContext() != null && node.getModel().getEndpointInitialContext().getNumberOfThreads() > 0) {
                Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap());
                endpoints.put(node.getQName(), (Endpoint<? extends EndpointType>)node);
                node.setListenersManager((ListenersManager)new ListenersManagerImpl(node.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
            } else {
                node.getListenedEndpoints().put(node.getQName(), node);
            }
            for (ExternalServer s : config.getExternalServers()) {
                ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).addExternalServer(s);
            }
        }
        catch (NoSuchInterfaceException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SCAException e) {
            throw new ESBException((Throwable)e);
        }
        log.fine("node " + name + " created and started");
        return node;
    }

    public Configuration getDefaultConfiguration() throws ESBException {
        return new ConfigurationImpl();
    }
}

