/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint;

import java.net.URI;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;

@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=ProviderEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ProviderEndpointImpl<M extends ProviderEndpointType> extends ClientEndpointImpl<M> implements ProviderEndpoint<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Service<? extends ServiceType> service;
	
	public ProviderEndpointImpl() {
		super();
	}
	
	public ProviderEndpointImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}
	
	public Service<? extends ServiceType> getServiceProvider() {
		return this.service;
	}
	
	public void setServiceProvider(Service<? extends ServiceType> service) {
		this.service = service;
		if(this.model != null && service != null) {
			this.model.setService(this.service.getQName());
		}
	}

	public URI getWSDLDescriptionAddress() {
	    if(this.model.getWsdlDescription() == null) return null;
		return URI.create(this.model.getWsdlDescription());
	}


	public void setWSDLDescriptionAddress(URI wsdl) {
		if(wsdl != null) {
			this.model.setWsdlDescription(wsdl.toString());
		}
	}
	
	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ProviderEndpointType.class;
		}
		return res;
	}
	
	@Override
	public URI getEndpointReference() {
		return URI.create("esb://" + this.getQName().getNamespaceURI() + "::" + this.service.getQName().getLocalPart() + "@" + this.getQName().getLocalPart());
	}
}
