/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific;


import java.net.URI;
import java.util.Map;
import java.util.logging.Logger;

import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.ClientProxyBehaviour;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

public class ClientProxyBehaviourImpl extends AbstractEndpointBehaviourImpl implements ClientProxyBehaviour {

	private static Logger log = Logger
	.getLogger(ClientProxyBehaviourImpl.class.getName());
	
	private boolean firstReading = true;

	private Map<URI, Document> imports = null;
	
	private Description desc = null;

	public ClientProxyBehaviourImpl(ClientProxyEndpoint<? extends ClientProxyEndpointType> ep) {
		super(ep);
	}

	public void execute(Exchange exchange) throws TransportException {
		try {
			this.sendExchange2InternalProviderEndpoint(exchange);
		} catch (TransportException e) {
			throw new TransportException(e);
		}
	}


	@SuppressWarnings("unchecked")
	public Exchange sendExchange2InternalProviderEndpoint(Exchange exchange)
	throws TransportException {
		// set echange
		exchange.setSource(((ClientProxyEndpoint)this.endpoint).getQName());
		exchange.setDestination(((ClientProxyEndpoint)this.endpoint).getProviderEndpointName());
		exchange.setServiceName(((ClientProxyEndpoint)this.endpoint).getProviderServiceName());
//		exchange.setPattern(PatternType.IN_OUT);

		log.finest("external request send to " + exchange.getDestination()+ " on operation: " + exchange.getOperation());
	
		
		// send exchange
		Exchange ex = ((ClientProxyEndpoint)this.endpoint).sendSync(exchange, 0);
		
		
		return ex;
	}

	@SuppressWarnings("unchecked")
	@Override
	public Description getDescription2Provider() {
		if(firstReading || desc == null) {
			try {
				desc = ((ClientProxyEndpoint)this.endpoint).getDescriptionOfProviderEndpoint(((ClientProxyEndpoint)this.endpoint).getProviderEndpointName());
				
//				this.imports = desc.deleteImportedDocumentsInWsdl(new URI(((ClientProxyEndpoint)this.endpoint).getExternalAddress() +"?wsdl="));
				
				this.endpoint.setDescription(desc);
			} catch (ESBException e) {
				e.printStackTrace();
				desc = null;
			} 
			this.firstReading = false;
		}
		return desc;
	}

	@Override
	public Map<URI, Document> getImports() {
		return imports;
	}

	@Override
	public Binding getBinding() {
		return null;
	}

	@Override
	public void setBinding(Binding b) {
		throw new UnsupportedOperationException();
	}

}
