/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

@Scope("COMPOSITE")
@Service(value=Component.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class ComponentImpl<M extends ComponentType> extends ProviderEndpointImpl<M> implements Component<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private static Logger log = Logger.getLogger(ComponentImpl.class.getName());

	private Map<QName, Endpoint<? extends EndpointType>> listenedEndpoints = new HashMap<QName, Endpoint<? extends EndpointType>>();

	private ListenersManagerImpl listenersManager = new ListenersManagerImpl(ListenersManagerImpl.DEFAULT_THREAD_COUNTER, listenedEndpoints); 
	

	public ComponentImpl() {
		super();
	}
	
	public ComponentImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}
	
	
	public ListenersManager getListenersManager() {
		return this.listenersManager;
	}

	public Map<QName, Endpoint<? extends EndpointType>> getListenedEndpoints() {
		return this.listenedEndpoints;
	}

	public void setListenedEndpoints(
			Map<QName, Endpoint<? extends EndpointType>> arg0) {
		this.listenedEndpoints = arg0;
	}

	public Class<M> getModelClass() {
		Class<M> res = null;
		if(model != null) {
			res = (Class<M>) model.getClass();
		} else {
			res = (Class<M>) ComponentType.class;
		}
		return res;
	}

	public void addProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		this.getSkeleton().addProviderEndpointInvocationInterceptor(i);
	}

	public ProviderEndpointInvocationInterceptor removeProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		return this.removeProviderEndpointInvocationInterceptor(i);
	}

	public List<ProviderEndpointInvocationInterceptor> getProviderEndpointInvocationInterceptor() {
		return this.getProviderEndpointInvocationInterceptor();
	}

	@Override
	public void start() throws TransportException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void stop() throws TransportException {
		// TODO Auto-generated method stub
		
	}

    @Override
    public Object getContext() {

        return null;
    }


}
