/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.component;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.TechnicalService;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ProviderEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.BusinessServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbComponentType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easyesb.ebmwebsourcing.com.soa.model.component.GetServices;
import easyesb.ebmwebsourcing.com.soa.model.component.GetServicesResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import esstar.petalslink.com.service.management._1_0.ManagementException;




public abstract class AbstractComponentBehaviourImpl extends AbstractEndpointBehaviourImpl implements ComponentBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AbstractComponentBehaviourImpl.class.getName());


	private Map<QName, Service<? extends ServiceType>> services = new HashMap<QName, Service<? extends ServiceType>>();




	public AbstractComponentBehaviourImpl(Component<? extends ComponentType> ep) {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public void execute(Exchange exchange) throws TransportException {
		try {
			log.finest("Component Name: " + this.getEndpoint().getName());
			log.finest("Component BEHAVIOUR FOUND: " + exchange.getOperation());
			log.finest("Component BEHAVIOUR FOUND: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().printMessage()));

			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getServices") &&
					QName.valueOf(exchange.getOperation()).getNamespaceURI()
					.equals("http://com.ebmwebsourcing.easyesb/soa/model/component")) {
				log.finest("getServices");
				
				GetServices request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetServices.class);
				GetServicesResponse response = this.getServices(request);
				
				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);
				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("deploy") &&
					QName.valueOf(exchange.getOperation()).getNamespaceURI()
					.equals("http://com.ebmwebsourcing.easyesb/soa/model/component")) {
				log.finest("deploy");
				
				GetServices request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetServices.class);
				GetServicesResponse response = this.getServices(request);
				
				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);
				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else {
				super.execute(exchange);
			}
		} catch (SOAException e) {
			log.severe("ESB Exception: " + e.getMessage());
			throw new TransportException(e);
		} 
	}

	public List<Service<? extends ServiceType>> getServices() {
		return new ArrayList<Service<? extends ServiceType>>(this.services.values());
	}



	@SuppressWarnings("unchecked")
	public <S extends Service<? extends ServiceType>> S createService(QName name, Class<S> serviceClass) throws ESBException {
		S service = null;
		try {

			// create model
			ServiceType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BusinessServiceType.class);
			
			if(TechnicalService.class.isAssignableFrom(serviceClass)) {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.TechnicalService.class);
				((TechnicalServiceType)model).setComponentParent(this.getEndpointQName());
			} else {
				model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.soa10.api.element.BusinessService.class);
				((BusinessServiceType)model).setComponentParent(this.getEndpointQName());
			}

			model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			model.getBehavioursList().addBehaviour(ServiceBehaviourImpl.class.getName());
			model.setType(serviceClass.getName());
			model.setEndpointInitialContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));
			model.setName(name);
			model.setService(this.getEndpointQName());
			model.setNode(this.getNodeQName());
			model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
			model.setProviderEndpointsGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ProviderEndpointsGroupList.class));

			RegistryService<?> registryService = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService();
			if(registryService != null) {

				// add service in registry
				boolean res = ((RegistryEndpointBehaviour)((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());

				if(res) {
					// get component
					service = (S) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
				}

			} else {
				
				Map<String, Object> context = new HashMap<String, Object>();
				context.put("model", model);
				context.put("parent", this.getEndpoint());

				// create component in composite
				org.objectweb.fractal.api.Component serviceComponent = SCAHelper.getSCAHelper().createNewComponent(serviceClass.getName(), context);
				SCAHelper.getSCAHelper().addComponent(serviceComponent, this.getEndpoint().getComponent(), null);
				SCAHelper.getSCAHelper().startComponent(serviceComponent);

				if(name != null) {
					SCAHelper.getSCAHelper().changeName(serviceComponent, name.toString());
				}

				service = (S) serviceComponent.getFcInterface("service");
				service.init();
				
				service.setNode((Node) this.getEndpoint().getNode());

				// create listener or add endpoint in listener node
				if((service.getModel().getEndpointInitialContext() != null)&&(service.getModel().getEndpointInitialContext().getNumberOfThreads() > 0)) {
					Map<QName, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap<QName, Endpoint<? extends EndpointType>>());
					endpoints.put(service.getQName(), service);
					service.setListenersManager(new ListenersManagerImpl(service.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
				} else {
					this.getEndpoint().getNode().getListenedEndpoints().put(service.getQName(), service);
				}
			}

			ComponentType ct = (ComponentType) this.endpoint.getModel();
			if(ct.getServicesGroupList() == null) {
				ct.setServicesGroupList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(ServicesGroupList.class));
			}
			ct.getServicesGroupList().addService(model);
			this.addService(service);
		} catch (SecurityException e) {
			throw new ESBException(e);
		} catch (IllegalArgumentException e) {
			throw new ESBException(e);
		} catch (RegistryFault_Exception e) {
			throw new ESBException(e);
		} catch (SCAException e) {
			throw new ESBException(e);
		} catch (NoSuchInterfaceException e) {
			throw new ESBException(e);
		}
		log.fine("service " + name + " created and started");
		return service;
	}


	public void addService(
			Service<? extends ServiceType> s) {
		this.services.put(s.getQName(), s);
	}


	public Service<? extends ServiceType> getService(
			QName name) {
		return this.services.get(name);
	}


	public Service<? extends ServiceType> removeService(
			Service<? extends ServiceType> s) throws ESBException {
		Service<? extends ServiceType> res = null;
		res = this.getService(s.getQName());
		if(res != null) {
			// delete model
			ComponentType ct = (ComponentType) this.endpoint.getModel();
			ct.getServicesGroupList().removeService(res.getModel());

			// delete in list
			this.services.remove(res);

			// delete in registry
			((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(res);
		}
		return res;
	}


	@Override
	public GetServicesResponse getServices(GetServices parameters) {
		GetServicesResponse response = new GetServicesResponse();
		response.setServicesGroupList(((EJaxbComponentType)((ComponentType)this.endpoint.getModel()).getModelObject()).getServicesGroupList());
		return response;
	}

	@Override
	public abstract EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws ManagementException;

	@Override
	public abstract List<String> getSupportedResourcesExtensions();



}
