/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.node;

import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryService;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BasicNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.element.TransporterList;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TransporterType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

@Scope("COMPOSITE")
@Service(value=Node.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class NodeImpl<M extends NodeType>  extends ComponentImpl<M> implements Node<M> {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(NodeImpl.class.getName());



    public NodeImpl() {
        super();
    }

    public NodeImpl(M model, SOAElement<?> parent) throws ESBException {
        super(model, parent);
    }


    @Override
    public void init()
            throws ESBException {
        super.init();

        this.model.setBasicNodeInformations(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BasicNodeInformations.class));
        this.model.getBasicNodeInformations().setTransporterList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(TransporterList.class));
        this.model.getBasicNodeInformations().getTransporterList().addTransporter(TransporterType.SOAP_TRANSPORTER);
        this.model.getBasicNodeInformations().setNodeName(this.model.getName());
    }

    @Override
    public TransportersManager getTransportersManager() throws ESBException {
        return ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getTransportersManager();
    }

    public RegistryEndpoint getRegistryEndpoint() throws ESBException {
        RegistryEndpoint res = null;
        RegistryService<?> registryService = ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getRegistryService();
        if(registryService != null) {
            res = registryService.findBehaviour(RegistryServiceBehaviour.class).getRegistryEndpoint();
        }
        return res;
    }

    public void start() throws TransportException {
        try {
            this.getTransportersManager().start();
            for(ExternalServer server: ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
                server.start();
            }
        } catch (ESBException e) {
            throw new TransportException(e);
        }

    }

    public void stop() throws TransportException {
        try {
            if(this.getTransportersManager() != null){
                this.getTransportersManager().stop();
            }
            ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).setTransportersManager(null);
        } catch (ESBException e) {
            throw new TransportException("Node not properly stopped", e);
        } finally {
            this.getListenersManager().shutdownAllListeners();
            for(ExternalServer server: ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getExternalServers()) {
                log.finest("stop external server \"" + server.getName() + "\" on port " + server.getPort());
                server.stop();
            }
            ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getExternalServers().clear();

            List<Component<? extends ComponentType>> components  = ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).getComponents();
            for(Component<? extends ComponentType> comp : components) {
                comp.stop();
            }
        }

        long timeout = 1000;
        long start = System.currentTimeMillis();
        while(!this.isStopped() && (System.currentTimeMillis() - start)<timeout){
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                //do nothing
            }
        }
        if(!this.isStopped()){
            log.warning("Node not properly stopped");
            throw new TransportException("Node not properly stopped");
        }
    }

    public boolean isStopped(){
        return ((NodeBehaviour)this.findBehaviour(NodeBehaviour.class)).isStopped();
    }

}
