/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa.impl.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;


import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ProviderEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.AbstractEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType;

@Scope("COMPOSITE")
@org.oasisopen.sca.annotation.Service(value=Service.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public abstract class ServiceImpl<M extends ServiceType> extends AbstractEndpointImpl<M> implements Service<M> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(ServiceImpl.class.getName());


	private List<ProviderEndpoint<? extends ProviderEndpointType>> endpoints = new ArrayList<ProviderEndpoint<? extends ProviderEndpointType>>();

	public ServiceImpl() {
		super();
	}

	public ServiceImpl(M model, SOAElement<?> parent) throws ESBException {
		super(model, parent);
	}


	public void addProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		this.getSkeleton().addProviderEndpointInvocationInterceptor(i);
	}

	public ProviderEndpointInvocationInterceptor removeProviderEndpointInvocationInterceptor(
			ProviderEndpointInvocationInterceptor i) {
		return this.getSkeleton().removeProviderEndpointInvocationInterceptor(i);
	}

	public ProviderEndpointInvocationInterceptor[] getProviderEndpointInvocationInterceptors() {
		return this.getSkeleton().getProviderEndpointInvocationInterceptors();
	}

	@SuppressWarnings("unchecked")
	@Override
	public ProviderEndpoint<? extends ProviderEndpointType>[] getEndpoints() {
		return endpoints.toArray(new  ProviderEndpoint[endpoints.size()]);
	}

	public void addEndpoints(ProviderEndpoint<? extends ProviderEndpointType>... ps) {
		endpoints.addAll(Arrays.asList(ps));
	}

	public void removeEndpoints(ProviderEndpoint<? extends ProviderEndpointType>... ps) {
		for(ProviderEndpoint p: ps) {
			endpoints.remove(p);
		}
	}

	@Override
	public URI getEndpointReference() {
		return URI.create("esb://" + this.getQName().getNamespaceURI() + "@" + this.getQName().getLocalPart());
	}
}
