/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.soa.impl.factory;

import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractExternalServerCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractRegistryCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractServiceCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.transport.TransportersManager;
import com.ebmwebsourcing.easyesb.soa.api.transport.listener.ListenersManager;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.node.NodeImpl;
import com.ebmwebsourcing.easyesb.soa.impl.transport.listener.ListenersManagerImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ESBCoreFactoryImpl
implements ESBCoreFactory {
    private static Logger log = Logger.getLogger(ESBCoreFactoryImpl.class.getName());
    protected Map<String, AbstractRegistryCreationFactory> registriesFactory = new HashMap<String, AbstractRegistryCreationFactory>();
    protected Map<String, AbstractServiceCreationFactory> servicesFactory = new HashMap<String, AbstractServiceCreationFactory>();
    protected Map<String, AbstractComponentCreationFactory> componentsFactory = new HashMap<String, AbstractComponentCreationFactory>();
    protected Map<String, AbstractExternalServerCreationFactory> externalServersFactory = new HashMap<String, AbstractExternalServerCreationFactory>();
    private List<String> factoryToExclude = null;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.endpoint.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.service.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.component.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.node.ObjectFactory.class, easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public ESBCoreFactoryImpl(String ... factoryToExclude) {
        this.factoryToExclude = Arrays.asList(factoryToExclude);
    }

    public Node createNode(QName name, Configuration config) throws ESBException {
        Node node = null;
        try {
            XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory();
            com.ebmwebsourcing.easyesb.soa10.api.element.Node model = (com.ebmwebsourcing.easyesb.soa10.api.element.Node)factory.create(com.ebmwebsourcing.easyesb.soa10.api.element.Node.class);
            model.setReference(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(name.getNamespaceURI(), name.getLocalPart(), null, new QueryParam[0])));
            model.setName(name.getLocalPart());
            model.setBehavioursList((BehavioursList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
            model.getBehavioursList().addBehaviour(NodeBehaviourImpl.class.getName());
            model.setServiceName(name);
            model.setNode(name);
            HashMap<String, com.ebmwebsourcing.easyesb.soa10.api.element.Node> context = new HashMap<String, com.ebmwebsourcing.easyesb.soa10.api.element.Node>();
            context.put("model", model);
            Component nodeComponent = SCAHelper.getSCAHelper().createNewComponent(NodeImpl.class.getName(), context);
            SCAHelper.getSCAHelper().startComponent(nodeComponent);
            if (name != null) {
                SCAHelper.getSCAHelper().changeName(nodeComponent, name.toString());
            }
            node = (Node)nodeComponent.getFcInterface("service");
            node.init();
            ((com.ebmwebsourcing.easyesb.soa10.api.element.Node)node.getModel()).setClientEndpointsGroupList((ClientEndpointsGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ClientEndpointsGroupList.class));
            node.setNode(node);
            node.getModel().setEndpointInitialContext((EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class));
            ((NodeType)node.getModel()).setServicesGroupList((ServicesGroupList)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ServicesGroupList.class));
            ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).setConfiguration(config);
            TransportersManager transportersManager = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createTransportersManager(String.valueOf(name.getLocalPart()) + "_transporterManager");
            transportersManager.setNode(node);
            if (node.getModel().getEndpointInitialContext() != null && node.getModel().getEndpointInitialContext().getNumberOfThreads() > 0) {
                Map<URI, Endpoint<? extends EndpointType>> endpoints = Collections.synchronizedMap(new HashMap());
                endpoints.put(node.getReference(), (Endpoint<? extends EndpointType>)node);
                node.setListenersManager((ListenersManager)new ListenersManagerImpl(node.getModel().getEndpointInitialContext().getNumberOfThreads(), endpoints));
            } else {
                node.getListenedEndpoints().put(node.getQName(), node);
            }
            this.createSPIExternalServer(node, config.getProperties());
            this.createSPIRegistry(node, config);
            this.createSPIService(node, config);
            if (((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getRegistryService() == null) {
                log.warning("No Registry Service defined. Distributed communication is not possible!!!!");
            }
            this.createSPIComponent(node, config);
        }
        catch (NoSuchInterfaceException e) {
            throw new ESBException((Throwable)e);
        }
        catch (SCAException e) {
            throw new ESBException((Throwable)e);
        }
        log.fine("node " + name + " created and started");
        return node;
    }

    private void createSPIExternalServer(Node node, Map<String, String> properties) throws ESBException {
        ServiceLoader<AbstractExternalServerCreationFactory> componentLoader = ServiceLoader.load(AbstractExternalServerCreationFactory.class);
        componentLoader.reload();
        for (AbstractExternalServerCreationFactory command : componentLoader) {
            if (this.factoryToExclude.contains(command.getId())) continue;
            ExternalServer server = command.createExternalServer((ESBCoreFactory)this, properties);
            this.externalServersFactory.put(command.getId(), command);
            ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).addExternalServer(server);
            log.info("SPI: external server \"" + command.getId() + "\" is created");
        }
    }

    private void createSPIComponent(Node node, Configuration conf) throws ESBException {
        ServiceLoader<AbstractComponentCreationFactory> componentLoader = ServiceLoader.load(AbstractComponentCreationFactory.class);
        componentLoader.reload();
        for (AbstractComponentCreationFactory command : componentLoader) {
            if (this.factoryToExclude.contains(command.getId())) continue;
            command.createComponent((ESBCoreFactory)this, node, conf);
            this.componentsFactory.put(command.getId(), command);
            log.info("SPI: component \"" + command.getId() + "\" is created");
        }
    }

    private void createSPIService(Node node, Configuration conf) throws ESBException {
        ServiceLoader<AbstractServiceCreationFactory> serviceLoader = ServiceLoader.load(AbstractServiceCreationFactory.class);
        serviceLoader.reload();
        for (AbstractServiceCreationFactory command : serviceLoader) {
            if (this.factoryToExclude.contains(command.getId())) continue;
            command.createService((ESBCoreFactory)this, node, conf);
            this.servicesFactory.put(command.getId(), command);
            log.info("SPI: service \"" + command.getId() + "\" is created");
        }
    }

    private void createSPIRegistry(Node node, Configuration conf) throws ESBException {
        ServiceLoader<AbstractRegistryCreationFactory> serviceLoader = ServiceLoader.load(AbstractRegistryCreationFactory.class);
        serviceLoader.reload();
        for (AbstractRegistryCreationFactory command : serviceLoader) {
            if (this.factoryToExclude.contains(command.getId())) continue;
            command.createService((ESBCoreFactory)this, node, conf);
            this.registriesFactory.put(command.getId(), command);
            log.info("SPI: registry \"" + command.getId() + "\" is created");
        }
    }

    public Configuration getDefaultConfiguration() throws ESBException {
        return new ConfigurationImpl();
    }
}

