/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.api.type;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.soa10.api.element.LocalEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.NeighbourNode;
import com.ebmwebsourcing.easyesb.soa10.api.element.RemoteEndpointsGroupList;


public interface RegistryEndpointType extends ProviderEndpointType {


	NeighbourNode[] getNeighbourNodes();

    void addNeighbourNode(NeighbourNode nn);

    void removeNeighbourNode(NeighbourNode nn);

    void clearNeighbourNodes();

    NeighbourNode getNeighbourNodeByName(QName name);
    
    
	
    LocalEndpointsGroupList getLocalEndpointsList();

    void setLocalEndpointsList(LocalEndpointsGroupList le);

    boolean hasLocalEndpointsList();

    
    
    RemoteEndpointsGroupList getRemoteEndpointsList();

    void setRemoteEndpointsList(RemoteEndpointsGroupList le);

    boolean hasRemoteEndpointsList();
    

	   
}
