/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointsGroupListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointsGroupListType;


class ProviderEndpointsGroupListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbProviderEndpointsGroupListType> implements
ProviderEndpointsGroupListType {

	protected ProviderEndpointsGroupListTypeImpl(XmlContext xmlContext, EJaxbProviderEndpointsGroupListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbProviderEndpointsGroupListType> getCompliantModelClass() {
		return EJaxbProviderEndpointsGroupListType.class;
	}


	@Override
	public ProviderEndpointType[] getProviderEndpoints() {
		return createChildrenArray(getModelObject()
				.getProviderEndpointGroup(), EJaxbProviderEndpointType.class,
				ANY_QNAME, ProviderEndpointType.class);
	}


	@Override
	public void addProviderEndpoint(ProviderEndpointType pe) {
		addToChildren(getModelObject().getProviderEndpointGroup(), pe);
	}


	@Override
	public void removeProviderEndpoint(ProviderEndpointType pe) {
		removeFromChildren(getModelObject().getProviderEndpointGroup(), pe);
	}


	@Override
	public void clearProviderEndpoints() {
		clearChildren(getModelObject().getProviderEndpointGroup(),
				EJaxbProviderEndpointType.class, ANY_QNAME);
	}


	@Override
	public ProviderEndpointType getProviderEndpointByName(QName name) {
		ProviderEndpointType res = null;
		for(ProviderEndpointType pe: this.getProviderEndpoints()) {
			if(pe.getName().equals(name)) {
				res = pe;
				break;
			}
		}
		return res;
	}





}
