/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;




import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointsGroupListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointsGroupListType;


class ClientEndpointsGroupListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbClientEndpointsGroupListType> implements
ClientEndpointsGroupListType {

	protected ClientEndpointsGroupListTypeImpl(XmlContext xmlContext, EJaxbClientEndpointsGroupListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbClientEndpointsGroupListType> getCompliantModelClass() {
		return EJaxbClientEndpointsGroupListType.class;
	}


	@Override
	public ClientEndpointType[] getClientEndpoints() {
		return createChildrenArray(getModelObject()
				.getClientEndpointGroup(), EJaxbClientEndpointType.class,
				ANY_QNAME, ClientEndpointType.class);
	}


	@Override
	public void addClientEndpoint(ClientEndpointType pe) {
		addToChildren(getModelObject().getClientEndpointGroup(), pe);
	}


	@Override
	public void removeClientEndpoint(ClientEndpointType pe) {
		removeFromChildren(getModelObject().getClientEndpointGroup(), pe);
	}


	@Override
	public void clearClientEndpoints() {
		clearChildren(getModelObject().getClientEndpointGroup(),
				EJaxbClientEndpointType.class, ANY_QNAME);
	}


	@Override
	public ClientEndpointType getClientEndpointByReference(String ref) {
		ClientEndpointType res = null;
		for(ClientEndpointType pe: this.getClientEndpoints()) {
			if(pe.getReference().equals(ref)) {
				res = pe;
				break;
			}
		}
		return res;
	}





}
