/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.ClientEndpointsGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.element.Component;
import com.ebmwebsourcing.easyesb.soa10.api.element.Registry;
import com.ebmwebsourcing.easyesb.soa10.api.element.ServicesGroupList;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointsGroupListType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbComponentType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbServicesGroupListType;

class NodeTypeImpl extends EndpointTypeImpl<EJaxbNodeType> implements
NodeType {

	protected NodeTypeImpl(XmlContext xmlContext, EJaxbNodeType jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbNodeType> getCompliantModelClass() {
		return EJaxbNodeType.class;
	}

	@Override
	public Registry getRegistry() {
		if(getModelObject().getRegistry() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getRegistry(), Registry.class);
		}
		return null;
	}

	@Override
	public void setRegistry(Registry value) {
		setChild(value, Registry.class);
	}

	@Override
	public boolean hasRegistry() {
		return this.getRegistry() != null;
	}


	@Override
	public Component[] getComponents() {
		return createChildrenArray(getModelObject()
                .getComponent(), EJaxbComponentType.class,
                ANY_QNAME, Component.class);
	}

	@Override
	public void addComponent(Component pe) {
		addToChildren(getModelObject().getComponent(), pe);
	}

	@Override
	public void removeComponent(Component pe) {
		removeFromChildren(getModelObject().getComponent(), pe);
	}

	@Override
	public void clearComponents() {
		clearChildren(getModelObject().getComponent(),
				EJaxbComponentType.class, ANY_QNAME);
	}

	@Override
	public Component getComponentByReference(String ref) {
		Component res = null;
		for(Component pe: this.getComponents()) {
			if(pe.getReference().equals(ref)) {
				res = pe;
				break;
			}
		}
		return res;
	}

	@Override
	public ServicesGroupList getServicesGroupList() {
		if(getModelObject().getServicesGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getServicesGroupList(), ServicesGroupList.class);
		}
		return null;
	}
	
	@Override
	public void setServicesGroupList(ServicesGroupList value) {
		if(value != null) {
			this.getModelObject().setServicesGroupList((EJaxbServicesGroupListType) ((AbstractXmlObjectImpl<?>) value).getModelObject());
		} else {
			this.getModelObject().setServicesGroupList(null);
		}
	}

	@Override
	public boolean hasServicesGroupList() {
		return this.getServicesGroupList() != null;
	}


	@Override
	public ClientEndpointsGroupList getClientEndpointsGroupList() {
		if(getModelObject().getClientEndpointsGroupList() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getClientEndpointsGroupList(), ClientEndpointsGroupList.class);
		}
		return null;
	}

	@Override
	public void setClientEndpointsGroupList(ClientEndpointsGroupList value) {
		if(value != null) {
			this.getModelObject().setClientEndpointsGroupList((EJaxbClientEndpointsGroupListType) ((AbstractXmlObjectImpl<?>) value).getModelObject());
		} else {
			this.getModelObject().setClientEndpointsGroupList(null);
		}
	}

	@Override
	public boolean hasClientEndpointsGroupList() {
		return this.getClientEndpointsGroupList() != null;
	}

	@Override
	public QName getServiceName() {
		return this.getModelObject().getServiceName();
	}

	@Override
	public void setServiceName(QName value) {
		this.getModelObject().setServiceName(value);
	}

	@Override
	public boolean hasServiceName() {
		return this.getServiceName() != null;
	}

	@Override
	public String getWsdlDescription() {
		return this.getModelObject().getWsdlDescription();
	}

	@Override
	public void setWsdlDescription(String value) {
		this.getModelObject().setWsdlDescription(value);
	}

	@Override
	public boolean hasWsdlDescription() {
		return this.getWsdlDescription() != null;
	}

	@Override
	public EJaxbNodeType getInternalModel() {
		return this.getModelObject();
	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String endpoint) {
		this.getModelObject().setName(endpoint);
	}

	@Override
	public boolean hasName() {
		return this.getName() != null;
	}


}
