/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;








import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.TransporterListType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TransporterType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTransporterListType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTransporterType;


class TransporterListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbTransporterListType> implements
TransporterListType {

	protected TransporterListTypeImpl(XmlContext xmlContext, EJaxbTransporterListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbTransporterListType> getCompliantModelClass() {
		return EJaxbTransporterListType.class;
	}


	@Override
	public TransporterType[] getTransporters() {
		TransporterType[] res = new TransporterType[getModelObject().getTransporter().size()];
		int i = 0;
		for(EJaxbTransporterType t: getModelObject().getTransporter()) {
			if(t.equals(TransporterType.SOAP_TRANSPORTER)) {
				res[i] = TransporterType.SOAP_TRANSPORTER;
			} else {
				throw new RuntimeException("Not Implemented");
			}
			i++;
		}
		
		return (TransporterType[]) getModelObject().getTransporter().toArray();
	}


	@Override
	public void addTransporter(TransporterType pe) {
		if(pe.equals(TransporterType.SOAP_TRANSPORTER)) {
			getModelObject().getTransporter().add(EJaxbTransporterType.SOAP_TRANSPORTER);
		} else {
			throw new RuntimeException("Not Implemented");
		}
	}


	@Override
	public void removeTransporter(TransporterType pe) {
		if(pe.equals(TransporterType.SOAP_TRANSPORTER)) {
			getModelObject().getTransporter().remove(EJaxbTransporterType.SOAP_TRANSPORTER);
		} else {
			throw new RuntimeException("Not Implemented");
		}
	}


	@Override
	public void clearTransporters() {
		this.getModelObject().getTransporter().clear();
	}




}
