/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.soa10.impl;





import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.BehavioursListType;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBehavioursListType;


class BehavioursListTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbBehavioursListType> implements
BehavioursListType {

	protected BehavioursListTypeImpl(XmlContext xmlContext, EJaxbBehavioursListType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbBehavioursListType> getCompliantModelClass() {
		return EJaxbBehavioursListType.class;
	}


	@Override
	public String[] getBehaviours() {
		return  this.getModelObject().getBehaviour().toArray(new String[this.getModelObject().getBehaviour().size()]);
	}


	@Override
	public void addBehaviour(String b) {
		this.getModelObject().getBehaviour().add(b);
	}


	@Override
	public void removeBehaviour(String b) {
		this.getModelObject().getBehaviour().remove(b);
	}


	@Override
	public void clearBehaviours() {
		this.getModelObject().getBehaviour().clear();		
	}


	@Override
	public String getBehaviourByName(String name) {
		String behaviourName = null;
		for(String b: this.getModelObject().getBehaviour()) {
			if(b.equals(name)) {
				behaviourName = b;
				break;
			}
		}
		return behaviourName;
	}



}
