/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.ws.Holder;

import org.jdom.input.DOMBuilder;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin10.api.element.EndpointInformation;
import com.ebmwebsourcing.easyesb.admin10.api.type.EndpointInformationType;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPSenderImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.EndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.BusinessService;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.ImportUtil;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BasicNodeInformations;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.GenericEndpoint;
import com.ebmwebsourcing.easyesb.soa10.api.element.NeighbourNode;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientProxyEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.event.EventSender;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.event.NodeProducersLocalisationManager;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyevent.AdminProxyEventManagerImpl;
import com.ebmwebsourcing.easyevent.AdminProxyEventManagerImpl.Mode;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;

import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbEndpointInformationType;
import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbPropertyType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbGenericEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformation;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformationTypeType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbFault;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbInterfaceConnectorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddEndpoint;
import easyesb.ebmwebsourcing.com.soa.model.registry.AddEndpointResponse;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import easyesb.petalslink.com.data.admin._1.AddPropertiesResponse;
import easyesb.petalslink.com.data.admin._1.AddSoapListener;
import easyesb.petalslink.com.data.admin._1.AddSoapListenerResponse;
import easyesb.petalslink.com.data.admin._1.ConnectToGovernance;
import easyesb.petalslink.com.data.admin._1.ConnectToGovernanceResponse;
import easyesb.petalslink.com.data.admin._1.CreateClientEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateClientEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateComponent;
import easyesb.petalslink.com.data.admin._1.CreateComponentResponse;
import easyesb.petalslink.com.data.admin._1.CreateProviderEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateProviderEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateService;
import easyesb.petalslink.com.data.admin._1.CreateServiceEndpoint;
import easyesb.petalslink.com.data.admin._1.CreateServiceEndpointResponse;
import easyesb.petalslink.com.data.admin._1.CreateServiceResponse;
import easyesb.petalslink.com.data.admin._1.ExposeServiceEndpointInSoap;
import easyesb.petalslink.com.data.admin._1.ExposeServiceEndpointInSoapResponse;
import easyesb.petalslink.com.data.admin._1.GetAdditionalContent;
import easyesb.petalslink.com.data.admin._1.GetAdditionalContentResponse;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpoints;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpointsResponse;
import easyesb.petalslink.com.data.admin._1.GetContent;
import easyesb.petalslink.com.data.admin._1.GetContentResponse;
import easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformation;
import easyesb.petalslink.com.data.admin._1.GetExecutionEnvironmentInformationResponse;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import easyesb.petalslink.com.data.admin._1.GetProperties;
import easyesb.petalslink.com.data.admin._1.GetPropertiesResponse;
import easyesb.petalslink.com.data.admin._1.GetResourceIdentifiers;
import easyesb.petalslink.com.data.admin._1.GetResourceIdentifiersResponse;
import easyesb.petalslink.com.data.admin._1.ImportSoapEndpoint;
import easyesb.petalslink.com.data.admin._1.ImportSoapEndpointResponse;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.ObjectFactory;
import easyesb.petalslink.com.data.admin._1.StoreBpel;
import easyesb.petalslink.com.data.admin._1.StoreBpelResponse;
import easyesb.petalslink.com.data.admin._1.UnconnectToGovernance;
import easyesb.petalslink.com.data.admin._1.UnconnectToGovernanceResponse;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpoint;
import easyesb.petalslink.com.data.admin._1.WrapSoapEndpointResponse;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AddEventRegistryFault;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.RemoveEventRegistryFault;
import esstar.petalslink.com.service.management._1_0.ManagementException;



public class BaseAdminEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements BaseAdminEndpointBehaviour {

	private Logger log = Logger.getLogger(BaseAdminEndpointBehaviourImpl.class.getName());

	private ObjectFactory factory = new ObjectFactory();

	private static easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory registryFactory = new easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory();
	private static com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory rscFactory = new com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory();

	private AdminProxyEventManagerImpl pem = null;

	private static Binding b; 


	static {
		try {
			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class, com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory.class,
					easyesb.ebmwebsourcing.com.soa.model.registry.ObjectFactory.class,
					com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.ObjectFactory.class,
					com.ebmwebsourcing.wsstar.jaxb.notification.topics.ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}

		try {

			URL url = Thread.currentThread().getContextClassLoader().getResource(DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			b = desc.getBindings().iterator().next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public BaseAdminEndpointBehaviourImpl(AdminEndpoint<? extends ProviderEndpointType> ep) throws ESBException {
		super(ep);
		this.setBinding(b);
		try {
			SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
			if(soapServer == null) {
				throw new ESBException("Soap server cannot be null");
			}
			String externalAddress = "http://" + ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getHost() + ":" + soapServer.getPort() + "/services/adminExternalEndpoint";
			System.out.println("externalAddress = " + externalAddress);
			EventSender eventSender = new EventSender((ProviderEndpoint<? extends EndpointType>) this.getEndpoint(), externalAddress);
			NodeProducersLocalisationManager producersLocator = new NodeProducersLocalisationManager(this.getEndpoint());	


			String modeS = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getConfiguration().getProperties().get(BaseAdminEndpointBehaviour.EVENT_MANAGER_MODE);
			Mode mode = Mode.SUBSCRIBER;
			if("broker".equals(modeS)) {
				mode = Mode.BROKER;
			}

			this.pem = new AdminProxyEventManagerImpl(mode, producersLocator, eventSender);
		} catch (WsnbException e) {
			throw new ESBException(e);
		}
	}



	public void execute(Exchange exchange) throws TransportException {
		try {
			if(exchange.getMessageIn().getBody().getPayload() == null) {
				throw new TransportException("the message in cannot be null");
			}

			// convert dom to jdom
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());

			if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("createComponent")) {
				log.finest("CREATE COMPONENT METHOD");

				CreateComponent createComponent = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateComponent.class);
				Holder<QName> res = new Holder<QName>(createComponent.getComponentName());
				this.createComponent(res, createComponent.getClassComponentName());

				CreateComponentResponse createComponentResponse = factory.createCreateComponentResponse();
				createComponentResponse.setComponentName(res.value);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createComponentResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("createService")) {

				log.finest("CREATE SERVICE METHOD");
				CreateService createService = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateService.class);
				Holder<QName> res = new Holder<QName>(createService.getServiceName());
				this.createService(createService.getComponentName(), res, createService.getClassServiceName());

				CreateServiceResponse createServiceResponse = factory.createCreateServiceResponse();
				createServiceResponse.setServiceName(res.value);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createServiceResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("createClientEndpoint")) {

				log.info("CREATE CLIENT ENDPOINT METHOD");
				CreateClientEndpoint createClientEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateClientEndpoint.class);
				Holder<QName> res = new Holder<QName>(createClientEndpoint.getClientEndpointName());
				this.createClientEndpoint(res, createClientEndpoint.getClassClientEndpointName(), createClientEndpoint.getClassClientEndpointBehaviourName());

				CreateClientEndpointResponse createClientEndpointResponse = factory.createCreateClientEndpointResponse();
				createClientEndpointResponse.setClientEndpointName(res.value);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createClientEndpointResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("createProviderEndpoint")) {

				log.info("CREATE PROVIDER ENDPOINT METHOD");
				CreateProviderEndpoint createProviderEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateProviderEndpoint.class);
				Holder<String> res = new Holder<String>(createProviderEndpoint.getProviderEndpointName());
				this.createProviderEndpoint(createProviderEndpoint.getServiceName(), res, createProviderEndpoint.getClassProviderEndpointName(), createProviderEndpoint.getClassProviderEndpointBehaviourName(), createProviderEndpoint.getWsdl());

				CreateProviderEndpointResponse createProviderEndpointResponse = factory.createCreateProviderEndpointResponse();
				createProviderEndpointResponse.setProviderEndpointName(res.value);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createProviderEndpointResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("exposeServiceEndpointInSoap")) {

				log.info("EXPOSE SERVICE ENDPOINT IN SOAP");
				ExposeServiceEndpointInSoap exposeServiceEndpointInSoap = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ExposeServiceEndpointInSoap.class);
				String res = this.exposeServiceEndpointInSoap(exposeServiceEndpointInSoap.getServiceName(), exposeServiceEndpointInSoap.getProviderEndpointName());

				ExposeServiceEndpointInSoapResponse exposeServiceEndpointInSoapResponse = factory.createExposeServiceEndpointInSoapResponse();
				exposeServiceEndpointInSoapResponse.setSoapAddress(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(exposeServiceEndpointInSoapResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("createServiceEndpoint")) {

				log.info("CREATE SERVICE ENDPOINT METHOD");
				CreateServiceEndpoint createServiceEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateServiceEndpoint.class);

				String res = this.createServiceEndpoint(createServiceEndpoint.getComponentName(), createServiceEndpoint.getServiceName(), createServiceEndpoint.getClassServiceName(), createServiceEndpoint.getProviderEndpointName(), createServiceEndpoint.getClassProviderEndpointName(), createServiceEndpoint.getClassProviderEndpointBehaviourName(), createServiceEndpoint.getWsdl());

				CreateServiceEndpointResponse createServiceEndpointResponse = factory.createCreateServiceEndpointResponse();
				createServiceEndpointResponse.setEndpointName(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createServiceEndpointResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);				

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("importSoapEndpoint")) {
				log.info("IMPORT SOAP ENDPOINT METHOD");

				ImportSoapEndpoint importSoapEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ImportSoapEndpoint.class);

				String res = this.importSoapEndpoint(importSoapEndpoint.getSoapAddress(), importSoapEndpoint.getWsdl());

				ImportSoapEndpointResponse importSoapEndpointResponse = factory.createImportSoapEndpointResponse();
				importSoapEndpointResponse.setEndpointName(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(importSoapEndpointResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("wrapSoapEndpoint")) {
				log.info("WRAP SOAP ENDPOINT METHOD");

				WrapSoapEndpoint wrapSoapEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), WrapSoapEndpoint.class);

				String consumerSoapAddress = this.wrapSoapEndpoint(wrapSoapEndpoint.getSoapAddress(), wrapSoapEndpoint.getWsdl(), wrapSoapEndpoint.getInterceptorClassName());

				WrapSoapEndpointResponse wrapSoapEndpointResponse = factory.createWrapSoapEndpointResponse();
				wrapSoapEndpointResponse.setConsumerSoapAddress(consumerSoapAddress);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(wrapSoapEndpointResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("addSoapListener")) {
				log.info("ADD SOAP LISTENER METHOD");
				AddSoapListener addSoapListener = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), AddSoapListener.class);

				AddSoapListenerResponse addSoapListenerResponse = this.addSoapListener(addSoapListener);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(addSoapListenerResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("storeBpel")) {
				log.info("Store BPEL");

				StoreBpel storeBpel = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), StoreBpel.class);
				List<String> res = this.storeBpel(storeBpel.getBpelUrl());
				StoreBpelResponse storeBpelResponse = factory.createStoreBpelResponse();
				storeBpelResponse.getBpelEndpointAddress().addAll(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(storeBpelResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getNodeInformations")) {
				log.info("Get Node Informations");

				GetNodeInformations getNodeInformations = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetNodeInformations.class);

				GetNodeInformationsResponse getNodeInformationsResponse = this.getNodeInformations(getNodeInformations);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getNodeInformationsResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("addNeighBourNode")) {
				log.info("Add neighbour node");
				AddNeighBourNode addNeighBourNode = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), AddNeighBourNode.class);

				AddNeighBourNodeResponse addNeighBourNodeResponse = this.addNeighBourNode(addNeighBourNode);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(addNeighBourNodeResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("moveEnpointToNode")) {
				log.info("Move endpoint to node");
				MoveEnpointToNode moveEndpointToNode = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), MoveEnpointToNode.class);

				MoveEnpointToNodeResponse moveEndpointToNodeResponse = this.moveEnpointToNode(moveEndpointToNode);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(moveEndpointToNodeResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getBusinessEndpoints")) {
				log.info("Get Business Endpoint");
				GetBusinessEndpoints getBusinessEndpoints = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetBusinessEndpoints.class);

				GetBusinessEndpointsResponse getBusinessEndpointsResponse = this.getBusinessEndpoints(getBusinessEndpoints);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getBusinessEndpointsResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("stop")) {
				log.info("Stop node");

				this.stop();
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getProperties")) {
				log.info("Get Properties");
				GetProperties getProperties = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetProperties.class);

				GetPropertiesResponse getPropertiesResponse = this.getProperties(getProperties);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getPropertiesResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("addProperties")) {
				log.info("Add Properties");
				AddProperties addProperties = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), AddProperties.class);

				AddPropertiesResponse addPropertiesResponse = this.addProperties(addProperties);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(addPropertiesResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			}  else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Subscribe")) {
				log.info("SUBSCRIBE");

				System.out.println("SUBSCRIBE IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
				Subscribe subs = WSNHelper.marshallSubscribe(exchange.getMessageIn().getBody().getPayload());
				SubscribeResponse res = this.subscribe(subs);
				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(res);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Unsubscribe")) {
				log.info("UNSUBSCRIBE");

				Unsubscribe unsubscribe = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), Unsubscribe.class);
				UnsubscribeResponse response = this.unsubscribe(unsubscribe);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("Notify")) {
				log.info("NOTIFY");

				System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
				Notify notify =  WSNHelper.marshallNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);

			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("GetResourceProperty")) {
				log.info("GET_RESOURCE_PROPERTY");

				QName property = null;
				String value = exchange.getMessageIn().getBody().getPayload().getDocumentElement().getTextContent();
				String prefix = null;
				String ns = null;
				String lp = null;
				if(value.contains(":")) {
					prefix = value.trim().split(":")[0];
					lp = value.trim().split(":")[1];
					ns = exchange.getMessageIn().getBody().getPayload().lookupNamespaceURI(prefix);
					property = new QName(ns, lp, prefix);
				} else {
					property = new QName(lp);
				}
				GetResourcePropertyResponse response = this.getResourceProperty(property);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else  if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getExecutionEnvironmentInformation")) {
				log.finest("CREATE getExecutionEnvironmentInformation METHOD");

				GetExecutionEnvironmentInformation request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetExecutionEnvironmentInformation.class);
				GetExecutionEnvironmentInformationResponse response = this.getExecutionEnvironmentInformation(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getResourceIdentifiers")) {
				log.finest("CREATE getResourceIdentifiers METHOD");

				GetResourceIdentifiers request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetResourceIdentifiers.class);
				GetResourceIdentifiersResponse response = this.getResourceIdentifiers(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getContent")) {
				log.finest("CREATE getContent METHOD");

				GetContent request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetContent.class);
				GetContentResponse response = this.getContent(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("getAdditionalContent")) {
				log.finest("CREATE getAdditionalContent METHOD");

				GetAdditionalContent request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAdditionalContent.class);
				GetAdditionalContentResponse response = this.getAdditionalContent(request);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("connectToGovernance")) {
				log.finest("CREATE connectToGovernance METHOD");

				ConnectToGovernance request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToGovernance.class);
				this.connectToGovernance(request.getAddress());
				ConnectToGovernanceResponse response = new ConnectToGovernanceResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("unconnectToGovernance")) {
				log.finest("CREATE unconnectToGovernance METHOD");

				UnconnectToGovernance request = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnconnectToGovernance.class);
				this.unconnectToGovernance(request.getAddress());
				UnconnectToGovernanceResponse response = new UnconnectToGovernanceResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			}
		} catch (ManagementException e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnableToDestroySubscriptionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			throw new TransportException(e);
		} catch (TopicNotSupportedFault e) {
			try {
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				Document docEx = null;
				if(e.getFaultInfo() != null) {
					docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				}
				Document fault = SOAPHandler.createSoapFault(docEx);
				exchange.getMessageError().getBody().setPayload(fault);				
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnsupportedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidTopicExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnrecognizedPolicyRequestFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (UnacceptableInitialTerminationTimeFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (NotifyMessageNotSupportedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidMessageContentExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SubscribeCreationFailedFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidFilterFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidProducerPropertiesExpressionFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (TopicExpressionDialectUnknownFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (ResourceUnavailableFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (InvalidResourcePropertyQNameFault e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (WsnbException e) {
			throw new TransportException(e);
		} 
	}

	@Override
	public void createClientEndpoint(Holder<QName> clientEndpointName,
			String classClientEndpointName,
			String classClientEndpointBehaviourName) throws ManagementException {
		Class<? extends ClientEndpointImpl> clazz;
		try {
			if(classClientEndpointName != null) {
				clazz = (Class<? extends ClientEndpointImpl<ClientEndpointType>>) Class.forName(classClientEndpointName);
			} else {
				clazz = (Class<ClientEndpointImpl>) ClientEndpointImpl.class;
			}

			// add behaviour
			Class<? extends EndpointBehaviour> clazzBehaviour = null;
			if(classClientEndpointBehaviourName != null && classClientEndpointBehaviourName.trim().length() > 0) {
				clazzBehaviour = (Class<? extends EndpointBehaviour>) Class.forName(classClientEndpointBehaviourName);
			}

			EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
			context.setNumberOfThreads(5);
			ClientEndpoint<ClientEndpointType> client = (ClientEndpoint<ClientEndpointType>) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).createClientEndpoint(clientEndpointName.value, clazz, clazzBehaviour, context);		
			client.addBehaviourClass(clazzBehaviour);


		} catch (ClassNotFoundException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}

	}

	@Override
	public void createComponent(Holder<QName> componentName,
			String classComponentName) throws ManagementException {
		Class<? extends ComponentImpl<ComponentType>> clazz;
		try {
			clazz = (Class<? extends ComponentImpl<ComponentType>>) Class.forName(classComponentName);
			this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class).createComponent(componentName.value, clazz);
		} catch (ClassNotFoundException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
	}

	@Override
	public void createProviderEndpoint(QName serviceName,
			Holder<String> providerEndpointName,
			String classProviderEndpointName,
			String classProviderEndpointBehaviourName, String wsdl)
					throws ManagementException {
		Class<? extends ProviderEndpointImpl> clazz;
		try {
			if(classProviderEndpointName != null) {
				clazz = (Class<? extends ProviderEndpointImpl>) Class.forName(classProviderEndpointName);
			} else {
				// default provider endpoint class
				clazz = ProviderEndpointImpl.class;
			}
			Service s = (Service) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(serviceName);
			if(s == null) {
				throw new ESBException("Impossible to find service " + serviceName + " in registry");
			}


			ProviderEndpoint providerEndpoint = null;
			EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
			context.setNumberOfThreads(5);


			providerEndpoint = (ProviderEndpoint) ((ServiceBehaviour)s.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(providerEndpointName.value, clazz, context);		

			// add behaviour
			if(classProviderEndpointBehaviourName != null && classProviderEndpointBehaviourName.trim().length() > 0) {
				Class<? extends EndpointBehaviour> clazzBehaviour = (Class<? extends EndpointBehaviour>) Class.forName(classProviderEndpointBehaviourName);
				providerEndpoint.addBehaviourClass(clazzBehaviour);
				if(wsdl != null) {
					URI uri = URI.create(wsdl);
					URL wsdlUrl = null;
					if(uri.toString().startsWith("classpath://")) {
						wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(uri.toString().replaceFirst("classpath://", ""));
					} else {
						wsdlUrl = uri.toURL();
					}

					providerEndpoint.setDescription((Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(wsdlUrl, Definitions.class)));
				}
			}
		} catch (ClassNotFoundException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (MalformedURLException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (IOException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (XmlObjectReadException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} 
	}

	@Override
	public void createService(QName componentName, Holder<QName> serviceName,
			String classServiceName) throws ManagementException {
		Class<? extends ServiceImpl> clazz;
		try {
			if(classServiceName != null) {
				clazz = (Class<? extends ServiceImpl>) Class.forName(classServiceName);
			} else {
				// default service class
				clazz = BusinessServiceImpl.class;
			}

			Component c = null;
			if(componentName != null) {
				c = (Component) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(componentName);
				if(c == null) {
					throw new ESBException("Impossible to find provider " + componentName + " in registry");
				}
			}

			// find if service exist
			Service service = (Service) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(serviceName.value);

			if(service == null) { 
				if(componentName == null) {
					// get default provider
					c = this.getEndpoint().getNode();
				}

				service = (Service) ((ComponentBehaviour)c.findBehaviour(ComponentBehaviour.class)).createService(serviceName.value, clazz);		
			}

		} catch (ClassNotFoundException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}

	}

	@Override
	public String createServiceEndpoint(QName componentName, QName serviceName,
			String classServiceName, String providerEndpointName,
			String classProviderEndpointName,
			String classProviderEndpointBehaviourName, String wsdl)
					throws ManagementException {
		Holder<QName> service = new Holder<QName>(serviceName);
		this.createService(componentName, service, classServiceName);

		Holder<String> provider = new Holder<String>(providerEndpointName);
		this.createProviderEndpoint(serviceName, provider, classProviderEndpointName, classProviderEndpointBehaviourName, wsdl);
		return provider.value;
	}

	public String importSoapEndpoint(String soapAddress, String wsdl)
			throws ManagementException {
		String res = null;
		try {

			URI uri = URI.create(wsdl);
			URL wsdlUrl = null;
			if(uri.toString().startsWith("classpath://")) {
				wsdlUrl = Thread.currentThread().getContextClassLoader().getResource(uri.toString().replaceFirst("classpath://", ""));
			} else {
				wsdlUrl = uri.toURL();
			}
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(wsdlUrl, Definitions.class));

			org.petalslink.abslayer.service.api.Service service = null;
			org.petalslink.abslayer.service.api.Endpoint endpoint = null;

			List<org.petalslink.abslayer.service.api.Service> services = new ArrayList<org.petalslink.abslayer.service.api.Service>();
			services.addAll(desc.getServices());
			for(org.petalslink.abslayer.service.api.Service s: services) {
				for(org.petalslink.abslayer.service.api.Endpoint ep: s.getEndpoints()) {
					if(ep.getAddress().equals(soapAddress)) {
						service = s;
						endpoint = ep;
						break;
					}
				}
				if(endpoint != null) {
					break;
				}
			}

			if(endpoint == null) {
				throw new ESBException("Impossible to find endpoint at this description: " + wsdl + " corresponding to this soap address: " + soapAddress);
			}

			String endpointQName = this.createServiceEndpoint(null, service.getQName(), null, endpoint.getName(), "com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl", "com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy.SoapProviderProxyBehaviourImpl", wsdl);
			ProviderEndpoint pe = (ProviderEndpoint) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(service.getQName().getNamespaceURI(),endpointQName));
			if(!(pe instanceof ProviderProxyEndpoint)) {
				throw new ESBException("Impossible to find provider endpoint: " + endpointQName + " on service " + service.getQName());
			}


			((ProviderProxyEndpoint)pe).setExternalAddress(soapAddress);
			((ProviderProxyEndpoint)pe).setWSDLDescriptionAddress(wsdlUrl.toURI());
			((ProviderProxyEndpoint)pe).getExternalSenders().put("soap", new SOAPSenderImpl());

			res = pe.getQName().toString();
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (MalformedURLException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (URISyntaxException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (IOException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (SOAPException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (XmlObjectReadException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
		return res;
	}

	public List<String> storeBpel(String bpelUrl) throws ManagementException {
		List<String> res = new ArrayList<String>();
		try {
			BPELComponent bpelComponent = (BPELComponent) ((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName("http://com.ebmwebsourcing.easyesb","BPELEngine"));
			if(bpelComponent == null) {
				throw new ESBException("Impossible to find bpel component on node: " + this.endpoint.getNode().getQName());
			}

			URL bpel = URI.create(bpelUrl).toURL();

			System.out.println("777777777777777777777777777777 resolver: " + ((URIMemoryMultipleResolvers)SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getURIResolver()));		
			BPELComponentBehaviour bpelComponentBehaviour = ((BPELComponentBehaviour)bpelComponent.findBehaviour(BPELComponentBehaviour.class));
			List<ProviderEndpointType> endpoints = bpelComponentBehaviour.store(bpel);

			SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(SoapServer.DEFAULT_NAME);
			for (ProviderEndpointType providerEndpointType : endpoints) {
				QName clientName = new QName(providerEndpointType.getName().getNamespaceURI(), providerEndpointType.getName().getLocalPart() + "_proxy");
				EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
				context.setNumberOfThreads(5);
				ClientProxyEndpoint proxyClientEndpoint = (ClientProxyEndpoint) ((NodeBehaviour)bpelComponent.getNode().findBehaviour(NodeBehaviour.class)).createClientEndpoint(clientName, ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, context);
				proxyClientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
				proxyClientEndpoint.setProviderServiceName(endpoints.get(0).getService());
				proxyClientEndpoint.setProviderEndpointName(endpoints.get(0).getName());
				SOAPListenerImpl soapListener = new SOAPListenerImpl(proxyClientEndpoint, soapServer); 
				proxyClientEndpoint.getExternalListeners().put("SOAP", soapListener);
				res.add(proxyClientEndpoint.getExternalAddress());
				//proxyClientEndpoint.getBehaviour();
			}

		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (MalformedURLException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (IllegalArgumentException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (Exception e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} 

		return res;
	}

	public String wrapSoapEndpoint(String soapAddress, String wsdl,
			List<String> interceptorClassName) throws ManagementException {
		String consumerSoapAddress = "";
		try {
			String endpointQName = this.importSoapEndpoint(soapAddress, wsdl);

			// find endpoint
			ProviderEndpoint pe = (ProviderEndpoint) ((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(QName.valueOf(endpointQName));
			if(!(pe instanceof ProviderEndpoint)) {
				throw new ESBException("Impossible to find provider endpoint: " + QName.valueOf(endpointQName));
			}

			consumerSoapAddress = this.exposeServiceEndpointInSoap(pe.getServiceProvider().getQName(), QName.valueOf(endpointQName).getLocalPart());
		} catch (ESBException e) {
			e.printStackTrace();
			log.severe(e.getMessage());
		}
		return consumerSoapAddress;
	}

	public String exposeServiceEndpointInSoap(QName serviceName,
			String providerEndpointName) throws ManagementException {
		String res = null;
		try {
			ProviderEndpoint pe = (ProviderEndpoint) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(serviceName.getNamespaceURI(), providerEndpointName));

			if(!(pe instanceof ProviderEndpoint)) {
				log.warning("Impossible to find provider endpoint: " + providerEndpointName + " on service " + serviceName);
			}

			Holder<QName> ceName = new Holder<QName>(new QName(serviceName.getNamespaceURI(), providerEndpointName + "ClientProxyEndpoint"));
			this.createClientEndpoint(ceName, ClientProxyEndpointImpl.class.getName(), ClientProxyBehaviourImpl.class.getName());


			// find proxy client endpoint
			ClientProxyEndpoint cpe = (ClientProxyEndpoint) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(ceName.value);
			if(!(cpe instanceof ClientProxyEndpoint)) {
				throw new ESBException("Impossible to find proxy client endpoint: " + ceName);
			}
			cpe.setProviderServiceName(serviceName);
			cpe.setProviderEndpointName(new QName(serviceName.getNamespaceURI(), providerEndpointName));


			AddSoapListener request = new AddSoapListener();
			request.setClientProxyEndpoint((EJaxbClientProxyEndpointType) ((ClientProxyEndpointType) cpe.getModel()).getModelObject());
			AddSoapListenerResponse response = this.addSoapListener(request);
			res = response.getExternalAddress();

			log.finest("load client description");
			cpe.getDescription();

		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
		return res;
	}


	@Override
	public AddSoapListenerResponse addSoapListener(AddSoapListener parameters)
			throws ManagementException {
		AddSoapListenerResponse res = null;
		try {
			ClientEndpoint ce = (ClientEndpoint) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(parameters.getClientProxyEndpoint().getName());
			if(!(ce instanceof ClientProxyEndpoint)) {
				throw new ESBException("Impossible to add listener on non-client proxy endpoint: " + parameters.getClientProxyEndpoint().getName());
			}
			ClientProxyEndpoint cpe = (ClientProxyEndpoint)ce;

			SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(SoapServer.DEFAULT_NAME);
			SOAPListenerImpl soapListener = new SOAPListenerImpl(cpe, soapServer); 
			cpe.getExternalListeners().put("SOAP", soapListener);

			// load behaviour
			//cpe.getBehaviour();

			res = new AddSoapListenerResponse();
			res.setExternalAddress(cpe.getExternalAddress());
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
		return res;
	}

	@Override
	public GetNodeInformationsResponse getNodeInformations(
			GetNodeInformations parameters) {
		GetNodeInformationsResponse res = new GetNodeInformationsResponse();
		res.setNode((EJaxbNodeType) this.getEndpoint().getNode().getModel().getModelObject());
		return res;
	}


	@Override
	public AddNeighBourNodeResponse addNeighBourNode(AddNeighBourNode parameters)
			throws ManagementException {
		AddNeighBourNodeResponse res = null;
		try {
			boolean added = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode(parameters.getNeighbourNode());

			// add admin endpoint
			EndpointType remoteAdminEndpoint = (EndpointType) SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.admin10.api.element.AdminEndpoint.class);
			remoteAdminEndpoint.setName(new QName(parameters.getNeighbourNode().getNodeName().getNamespaceURI(), "adminEndpoint_" + parameters.getNeighbourNode().getNodeName().getLocalPart()));
			remoteAdminEndpoint.setNode(parameters.getNeighbourNode().getNodeName());
			remoteAdminEndpoint.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
			remoteAdminEndpoint.getBehavioursList().addBehaviour(BaseAdminEndpointBehaviourImpl.class.getName());
			((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getRemoteEndpoints().put(remoteAdminEndpoint.getName(), remoteAdminEndpoint);

			res = new AddNeighBourNodeResponse();
			res.setOut(added);
		} catch (RegistryFault_Exception e) {
			log.severe("e message = " + e.getMessage());
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ESBException e) {
			log.severe("e message = " + e.getMessage());
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
		return res;
	}

	@Override
	public MoveEnpointToNodeResponse moveEnpointToNode(
			MoveEnpointToNode parameters) throws ManagementException {
		MoveEnpointToNodeResponse res = null;
		EndpointType endpoint = null;


		try {

			// get connection to remote node
			EJaxbBasicNodeInformationsType nodeInfos = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getNeighBourNode(parameters.getBasicNodeInformations().getNodeName());
			if(nodeInfos == null && parameters.isAddConnectionIfNotExist()) {
				boolean added = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addNeighBourNode(parameters.getBasicNodeInformations());
				if(added) {
					nodeInfos = parameters.getBasicNodeInformations();
				}
			}

			if(nodeInfos == null) {
				EJaxbFault fault = new EJaxbFault();
				fault.setMessage("the node " + this.endpoint.getNode().getQName() + " is not connected to " + parameters.getBasicNodeInformations().getNodeName());
				throw new ManagementException(fault.getMessage(), fault);
			}

			// get local endpoint
			Endpoint ep = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(parameters.getEndpointName());
			if(ep == null) {
				EJaxbFault fault = new EJaxbFault();
				fault.setMessage("Impossible to find endpoint " + parameters.getEndpointName() + " on node " + parameters.getBasicNodeInformations().getNodeName());
				throw new ManagementException(fault.getMessage(), fault);
			}

			if(ep instanceof ProviderEndpoint) {
				// move service 
				MoveEnpointToNode request = new MoveEnpointToNode();
				request.setEndpointName(((ProviderEndpoint)ep).getServiceProvider().getQName());
				request.setBasicNodeInformations(nodeInfos);
				request.setAddConnectionIfNotExist(parameters.isAddConnectionIfNotExist());

				this.moveEnpointToNode(request);
			}

			// add endpoint on remote node
			Exchange exchange = ((ClientEndpoint)this.getEndpoint()).getStub().createExchange();
			exchange.setDestination(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "registryEndpoint_" + parameters.getBasicNodeInformations().getNodeName().getLocalPart()));
			exchange.setPattern(PatternType.IN_OUT);
			exchange.setStatus(StatusType.ACTIVE);
			exchange.setInterfaceName(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "registryEndpointBehaviourItf"));
			exchange.setOperation(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "addEndpoint").toString());

			AddEndpoint request = registryFactory.createAddEndpoint();
			request.setEndpoint((EJaxbEndpointType) ((EndpointType) ep.getModel()).getModelObject());

			Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement(request);
			MessageUtil.getInstance().createInMessageStructure(exchange);
			exchange.getMessageIn().getBody().setPayload(doc);

			// send exchange
			Exchange responseExchange = ((ClientEndpoint)this.getEndpoint()).sendSync(exchange, 0);

			// get response
			AddEndpointResponse response = SOAJAXBContext.getInstance().marshallAnyType(responseExchange.getMessageOut().getBody().getPayload(), AddEndpointResponse.class);


			// set response
			if(response.isResult()) {

				if(ep instanceof ProviderEndpoint) {
					// delete service if has not endpoint
					if(((ServiceBehaviour)((ProviderEndpoint)ep).getServiceProvider().findBehaviour(ServiceBehaviour.class)).getProviderEndpoints().length == 0) {
						((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(((ProviderEndpoint)ep).getServiceProvider());
					}
				}

				// delete local endpoint
				ep = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).removeLocalEndpoint(ep);

				BasicNodeInformations basicNodeInformations = null;
				if(nodeInfos.getXmlObject() instanceof BasicNodeInformations) {
					basicNodeInformations = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(nodeInfos, BasicNodeInformations.class);
				} else if(nodeInfos.getXmlObject() instanceof NeighbourNode) {
					NeighbourNode neighBourNode = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().wrap(nodeInfos, NeighbourNode.class);
					basicNodeInformations = neighBourNode.duplicateXmlObjectAs(BasicNodeInformations.class); 
				} else {
					throw new ManagementException("type unknown: " + nodeInfos);
				}


				endpoint = (EndpointType) ep.getModel();
				endpoint.setNode(parameters.getBasicNodeInformations().getNodeName());
				endpoint.setBasicNodeInformations(basicNodeInformations);

				if(endpoint instanceof ClientProxyEndpointType) {
					// add soap listener
					Exchange exchange2 = ((ClientEndpoint)this.getEndpoint()).getStub().createExchange();
					exchange2.setDestination(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "adminEndpoint_" + parameters.getBasicNodeInformations().getNodeName().getLocalPart()));
					exchange2.setPattern(PatternType.IN_OUT);
					exchange2.setStatus(StatusType.ACTIVE);
					exchange2.setInterfaceName(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "AdminItf"));
					exchange2.setOperation(new QName(parameters.getBasicNodeInformations().getNodeName().getNamespaceURI(), "addSoapListener").toString());

					AddSoapListener addSoapListenerRequest = factory.createAddSoapListener();
					addSoapListenerRequest.setClientProxyEndpoint((EJaxbClientProxyEndpointType) ((ClientProxyEndpointType) endpoint).getModelObject());

					Document payload = SOAJAXBContext.getInstance().unmarshallAnyElement(addSoapListenerRequest);

					MessageUtil.getInstance().createInMessageStructure(exchange2);
					exchange2.getMessageIn().getBody().setPayload(payload);

					// send exchange
					Exchange addSoapListenerResponseExchange = ((ClientEndpoint)this.getEndpoint()).sendSync(exchange2, 0);

					// get response
					AddSoapListenerResponse addSoapListenerResponse = SOAJAXBContext.getInstance().marshallAnyType(addSoapListenerResponseExchange.getMessageOut().getBody().getPayload(), AddSoapListenerResponse.class);

				}
			}

			res = new MoveEnpointToNodeResponse();
			GenericEndpoint genericEndpoint = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(GenericEndpoint.class);
			genericEndpoint.setEndpoint(endpoint);
			res.setGenericEndpoint((EJaxbGenericEndpointType) genericEndpoint.getModelObject());
		} catch (ESBException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (RegistryFault_Exception e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (TransportException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (ExchangeException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (SOAException e) {
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		}
		return res;
	}

	public void stop() {
		try {
			this.getEndpoint().getNode().stop();
		} catch (TransportException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public GetBusinessEndpointsResponse getBusinessEndpoints(
			GetBusinessEndpoints parameters) throws ManagementException {
		GetBusinessEndpointsResponse res = null;
		List<EndpointInformationType> businessEndpoints = new ArrayList<EndpointInformationType>();

		try {
			List<Endpoint<? extends EndpointType>> endpoints = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoints();

			for(Endpoint<? extends EndpointType> ep: endpoints) {
				if(ep instanceof ProviderEndpoint) {
					ProviderEndpoint pep = (ProviderEndpoint) ep;
					if(pep.getServiceProvider() instanceof BusinessService) {
						EndpointInformationType epInfo = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInformation.class);
						epInfo.setName(pep.getQName());
						epInfo.setNode(pep.getNode().getQName());

						if(pep.getServiceProvider() == null) {
							throw new ESBException("Service name cannot be null!!!!");
						}
						epInfo.setService(pep.getServiceProvider().getQName());

						com.ebmwebsourcing.easyesb.admin10.api.element.Description d = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.admin10.api.element.Description.class);

						Description desc =  pep.getDescription();

						org.petalslink.abslayer.service.api.Service s = desc.findService(pep.getServiceProvider().getQName());
						if(s == null) {
							throw new ESBException("Impossible to find service \"" + pep.getServiceProvider().getQName() + "\" in corresponding description");
						}
						epInfo.addInterface(findUniqueInterfaceIfExist(s));

						Document descDoc = desc.write();
						((com.ebmwebsourcing.easyesb.admin10.api.element.Description)d).setContent(descDoc.getDocumentElement());
						epInfo.setDescription(d);

						businessEndpoints.add(epInfo);

					}
				}
			}

			res = new GetBusinessEndpointsResponse();
			for(EndpointInformationType businessEp : businessEndpoints) {
				res.getEndpointInformation().add((EJaxbEndpointInformationType) businessEp.getModelObject());
			}
		} catch (ESBException e) {
			log.severe("e message = " + e.getMessage());
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} catch (XmlObjectWriteException e) {
			log.severe("e message = " + e.getMessage());
			EJaxbFault fault = new EJaxbFault();
			fault.setMessage(e.getMessage());
			fault.setStacktrace(ErrorUtil.printStackTrace(e));
			throw new ManagementException(e.getMessage(), fault, e);
		} 

		return res;
	}

	private QName findUniqueInterfaceIfExist(
			org.petalslink.abslayer.service.api.Service s) {
		QName itf = null;
		for(org.petalslink.abslayer.service.api.Endpoint e: s.getEndpoints()) {
			if(itf == null) {
				itf = e.getBinding().getInterface().getQName();
			}
			if(!itf.equals(e.getBinding().getInterface().getQName())) {
				itf = null;
				break;
			}
		}
		return itf;
	}

	@Override
	public GetPropertiesResponse getProperties(GetProperties parameters)
			throws ManagementException {
		GetPropertiesResponse res = new GetPropertiesResponse();
		for(Entry<String, String> entry: ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration().getProperties().entrySet()) {
			EJaxbPropertyType property = new EJaxbPropertyType();
			property.setKey(entry.getKey());
			property.setValue(entry.getValue());
			res.getProperty().add(property);
		}
		return res;
	}

	@Override
	public AddPropertiesResponse addProperties(AddProperties parameters)
			throws ManagementException {
		AddPropertiesResponse res = new AddPropertiesResponse();
		for(EJaxbPropertyType property: parameters.getProperty())  {
			((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getConfiguration().addProperty(property.getKey(), property.getValue());
		}
		res.setResult(true);
		return res;
	}

	@Override
	public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest)
			throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault,
			ResourceUnknownFault {
		return this.pem.getResourceProperty(getResourcePropertyRequest);	
	}

	@Override
	public SubscribeResponse subscribe(Subscribe request)
			throws TopicNotSupportedFault, UnsupportedPolicyRequestFault,
			InvalidTopicExpressionFault, UnrecognizedPolicyRequestFault,
			UnacceptableInitialTerminationTimeFault,
			NotifyMessageNotSupportedFault, ResourceUnknownFault,
			InvalidMessageContentExpressionFault, SubscribeCreationFailedFault,
			InvalidFilterFault, InvalidProducerPropertiesExpressionFault,
			TopicExpressionDialectUnknownFault {
		return this.pem.subscribe(request);
	}

	@Override
	public UnsubscribeResponse unsubscribe(Unsubscribe arg0)
			throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
		throw new UnsupportedOperationException();
	}

	@Override
	public GetResourceIdentifiersResponse getResourceIdentifiers(
			GetResourceIdentifiers parameters) throws ManagementException {
		GetResourceIdentifiersResponse res = new GetResourceIdentifiersResponse();

		try {
			List<Endpoint<? extends EndpointType>> endpoints = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoints();

			for(Endpoint<? extends EndpointType> ep: endpoints) {
				if(ep instanceof ProviderEndpoint) {
					ProviderEndpoint pep = (ProviderEndpoint) ep;
					if(pep.getServiceProvider() instanceof BusinessService) {
						EJaxbResourceIdentifier epInfo = new EJaxbResourceIdentifier();
						EndpointAddress addr = new EndpointAddress(pep.getQName().getNamespaceURI(), pep.getServiceProvider().getQName().getLocalPart(), pep.getQName().getLocalPart());
						epInfo.setId(ESBUtil.generateURI(addr).toString());
						epInfo.setResourceType("endpoint");
						res.getResourceIdentifier().add(epInfo);
					}
				}
			}
		} catch (Throwable e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		} 
		return res;		
	}

	@Override
	public GetContentResponse getContent(GetContent parameters)
			throws ManagementException {
		GetContentResponse res = new GetContentResponse();
		try {
			EndpointAddress addr = ESBUtil.analyzeURI(URI.create(parameters.getResourceIdentifier().getId()));
			Endpoint pe = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(addr.getNamespace(), addr.getEndpointname()));
			if(pe == null) {
				throw new ManagementException("Impossible to find endpoint corresponding to this qname: " + parameters.getResourceIdentifier().getId());
			}
			Description desc = pe.getDescription();
			Document doc = desc.write();
			res.setAny(doc.getDocumentElement());
		} catch (Throwable e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		} 
		return res;
	}

	@Override
	public GetExecutionEnvironmentInformationResponse getExecutionEnvironmentInformation(
			GetExecutionEnvironmentInformation parameters)
					throws ManagementException {
		GetExecutionEnvironmentInformationResponse res = new GetExecutionEnvironmentInformationResponse();
		EJaxbExecutionEnvironmentInformation env = new EJaxbExecutionEnvironmentInformation();
		env.setName(this.getNodeQName().toString());
		env.setType(EJaxbExecutionEnvironmentInformationTypeType.ESB);
		env.setVersion("1.0-SNAPSHOT");

		SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
		if(soapServer == null) {
			throw new ManagementException("Soap server cannot be null");
		}


		easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory objFactory = new easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory();

		// set interface connector
		EJaxbInterfaceConnectorType itfSubscribeProducer = new EJaxbInterfaceConnectorType();
		itfSubscribeProducer.setId(objFactory.createEJaxbInterfaceConnectorTypeId("resourcesSubscriptionEndpoint"));
		itfSubscribeProducer.setInterfaceName(new QName("http://www.petalslink.com/wsn/service/WsnProducer", "NotificationProducer"));
		itfSubscribeProducer.setEndpointAddress("http://" + this.getEndpoint().getNode().getModel().getBasicNodeInformations().getHost() + ":" + soapServer.getConfig().getPort() + "/services/adminExternalEndpoint");
		env.getInterfaceConnector().add(itfSubscribeProducer);

		EJaxbInterfaceConnectorType itfUnSubscribeProducer = new EJaxbInterfaceConnectorType();
		itfUnSubscribeProducer.setId(objFactory.createEJaxbInterfaceConnectorTypeId("resourcesUnSubscriptionEndpoint"));
		itfUnSubscribeProducer.setInterfaceName(new QName("http://www.petalslink.com/wsn/service/WsnProducer", "PausableSubscriptionManager"));
		itfUnSubscribeProducer.setEndpointAddress("http://" + this.getEndpoint().getNode().getModel().getBasicNodeInformations().getHost() + ":" + soapServer.getConfig().getPort() + "/services/adminExternalEndpoint");
		env.getInterfaceConnector().add(itfUnSubscribeProducer);

		res.setExecutionEnvironmentInformation(env);
		return res;
	}

	@Override
	public GetAdditionalContentResponse getAdditionalContent(
			GetAdditionalContent parameters)
					throws ManagementException {
		GetAdditionalContentResponse res = new GetAdditionalContentResponse();
		try {
			EndpointAddress addr = ESBUtil.analyzeURI(URI.create(parameters.getResourceIdentifier().getId()));
			Endpoint pe = ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(addr.getNamespace(), addr.getEndpointname()));
			Description desc = pe.getDescription();
			String relativePath = parameters.getId();

			Document doc = ImportUtil.getInstance().findImportInDescription(desc, relativePath);
			if(doc == null) {
				EJaxbFault fault = new EJaxbFault();
				String msg = "Impossible to find ressource corresponding to " + relativePath + " on endpoint " + parameters.getResourceIdentifier().getId();
				fault.setMessage(msg);
				throw new ManagementException(msg, fault);
			}
			res.setAny(doc.getDocumentElement());
		} catch (Throwable e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		} 
		return res;
	}

	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws ManagementException {
		return ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).deploy(parameters);
	}

	@Override
	public void notify(Notify notify) {
		this.pem.notify(notify);
	}



	@Override
	public void connectToGovernance(String address) throws ManagementException {
		try {
			this.pem.addEventRegistry(address);
		} catch (AddEventRegistryFault e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		}
	}



	@Override
	public void unconnectToGovernance(String address) throws ManagementException {
		try {
			this.pem.removeEventRegistry(address);
		} catch (RemoveEventRegistryFault e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		}
	}


}





