/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.service;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.BehavioursList;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.service.AdminService;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.service.AdminServiceBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.AdminEndpointImpl;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.AdminManagementEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BaseAdminEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.UserManagementEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easyesb.ebmwebsourcing.com.soa.model.registry.RegistryFault_Exception;

public class AdminServiceBehaviourImpl extends ServiceBehaviourImpl implements AdminServiceBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(AdminServiceBehaviourImpl.class.getName());
	
	
	
	private AdminEndpoint<? extends ProviderEndpointType> adminEndpoint = null;
	
	
	public AdminServiceBehaviourImpl(AdminService<? extends TechnicalServiceType> ep) {
		super(ep);
	}
	
	public void execute(Exchange exchange) throws TransportException {
		this.execute(exchange);
		
	}

	@SuppressWarnings("unchecked")
	public AdminEndpoint<? extends ProviderEndpointType> createAdminEndpoint(
			String name, EndpointInitialContext context) throws ESBException {
		if(this.adminEndpoint == null) {
			try {
				
				ProviderEndpointType model = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(com.ebmwebsourcing.easyesb.admin10.api.element.AdminEndpoint.class);
				model.setBehavioursList(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(BehavioursList.class));
				model.getBehavioursList().addBehaviour(BaseAdminEndpointBehaviourImpl.class.getName());
				model.getBehavioursList().addBehaviour(UserManagementEndpointBehaviourImpl.class.getName());
				model.getBehavioursList().addBehaviour(AdminManagementEndpointBehaviourImpl.class.getName());
				model.setType(AdminEndpointImpl.class.getName());
				model.setEndpointInitialContext(context);
				model.setName(new QName(this.endpoint.getQName().getNamespaceURI(), name));
				model.setNode(this.getNodeQName());
				model.setBasicNodeInformations(this.endpoint.getModel().getBasicNodeInformations());
				model.setService(this.endpoint.getQName());

				
				// add service in registry
				if((this.getEndpoint().getNode() != null)&&(((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService() != null)) {
					boolean res = ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).addEndpoint((EJaxbEndpointType) model.getModelObject());
				
					if(res) {
						// get component
						adminEndpoint = (AdminEndpoint) ((RegistryEndpointBehaviour) ((RegistryServiceBehaviour)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getRegistryService().findBehaviour(RegistryServiceBehaviour.class)).getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(model.getName());
					
						BaseAdminEndpointBehaviour baseAdmin = adminEndpoint.findBehaviour(BaseAdminEndpointBehaviourImpl.class);
						if(baseAdmin == null) {
							throw new ESBException("BaseAdmin enpoint behaviour cannot be null!!!");
						}
						adminEndpoint.findBehaviour(UserManagementEndpointBehaviourImpl.class).setAdminEndpointBehaviour(baseAdmin);
						adminEndpoint.findBehaviour(AdminManagementEndpointBehaviourImpl.class).setAdminEndpointBehaviour(baseAdmin);
						
					}
				} else {
					throw new ESBException("Registry cannot be null"); 
				}
				
			} catch (RegistryFault_Exception e) {
				throw new ESBException(e);
			} 
			log.fine("adminEndpoint " + name + " created and started");
		}
		return this.adminEndpoint;
	}

	public AdminEndpoint<? extends ProviderEndpointType> getAdminEndpoint() {
		return this.adminEndpoint;
	}






}
