package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.event;

import javax.xml.namespace.QName;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyevent.AbstractEventSender;
import com.ebmwebsourcing.easyevent.impl.SOAPEventSender;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;

public class EventSender extends AbstractEventSender {

	private ProviderEndpoint<? extends EndpointType> endpoint = null;

	private SOAPEventSender soapEventSender = null;

	public EventSender(ProviderEndpoint<? extends EndpointType> endpoint, String externalAddr) {
		super(externalAddr);
		this.endpoint = endpoint;
		this.soapEventSender = new SOAPEventSender(externalAddr);
	}

	@Override
	public void notify(EndpointReferenceType epr, Notify notify) {
		try {
			if("http".equals(epr.getAddress().getValue().getScheme())) {
				this.soapEventSender.notify(epr, notify);
			} else {
				ProviderEndpoint subscriber;
				subscriber = (ProviderEndpoint) ((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(epr.getAddress().getValue());

				if(subscriber == null) {
					throw new ESBException("Impossible to find consumer event: " + epr.getAddress().getValue());
				}

				Exchange ex = ((ClientEndpoint<?>)this.endpoint).createExchange();
				ex.setDestinationReference(subscriber.getReference());
				ex.setInterfaceName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
				ex.setOperation("Notify");
				if(subscriber.getServiceProvider() != null) {
					ex.setServiceName(subscriber.getServiceProvider().getQName());
				} else {
					EndpointAddress epr2 = ESBUtil.analyzeURI(subscriber.getReference());
					String name = epr2.getEndpointname();
					if(name == null) {
						name = epr2.getServicename();
					}
					ex.setServiceName(new QName(epr2.getNamespace(), name));
				}
				ex.setPattern(PatternType.IN_ONLY);
				MessageUtil.getInstance().createInMessageStructure(ex);
				ex.getMessageIn().getBody().setPayload(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
				((ClientEndpoint)this.endpoint).send(ex);

			}
		} catch (Exception e) {
			// do nothing
			e.printStackTrace();
		} 
	}

	@Override
	public SubscribeResponse subscribe(EndpointReferenceType epr,
			Subscribe subscribe) throws UnacceptableInitialTerminationTimeFault,
			TopicExpressionDialectUnknownFault, InvalidTopicExpressionFault,
			NotifyMessageNotSupportedFault, TopicNotSupportedFault,
			UnsupportedPolicyRequestFault, ResourceUnknownFault,
			InvalidFilterFault, InvalidProducerPropertiesExpressionFault,
			UnrecognizedPolicyRequestFault,
			InvalidMessageContentExpressionFault, SubscribeCreationFailedFault {
		SubscribeResponse res = null;
		try {
			if("http".equals(epr.getAddress().getValue().getScheme())) {
				res = this.soapEventSender.subscribe(epr, subscribe);
			} else {
				Endpoint subscriber = ((RegistryEndpointBehaviour)this.endpoint.getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(epr.getAddress().getValue());
				NotificationProducerEndpointBehaviour behaviour = (NotificationProducerEndpointBehaviour) subscriber.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
				res = behaviour.subscribe(subscribe);
			}
		} catch (ESBException e) {
			throw new TopicNotSupportedFault(e.getMessage(), e);
		} catch (WsnbException e) {
			throw new TopicNotSupportedFault(e.getMessage(), e);
		} catch (AbsWSStarFault e) {
			throw new TopicNotSupportedFault(e.getMessage(), e);
		}
		return res;
	}

}
