package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;

public class ExposeCommand extends AbstractCommand<UserManagementClient> {

	private QName serviceQName;
	
	private String endpointName;
	
	
	public ExposeCommand(UserManagementClient client) throws ESBException {
		super(client);
		this.setShortcut("e");
		this.setName("Expose");
		this.setDescription("expose");
		
	}
	
	
	@Override
	public void execute() {
		String res = null;
		try {
				res = this.getClient().expose(this.serviceQName, this.endpointName);
				this.resultCode = AbstractCommand.OK_CODE;
		} catch (Throwable e) {
			this.setResult(e.getMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
		}
		
		this.setResult(res);

	}


	@Override
	protected int doProcess(List<String> args) {
		this.serviceQName = new QName(args.get(0), args.get(1));
		this.endpointName = args.get(2);
		execute();
		return this.resultCode;
	}


	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() != 3){
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "e <service-namespace> <service-localpart> <endpoint> {Expose internal Enpoint as Web Service}";
	}
	
}
