package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;


public class ConnectToGovernanceCommand extends AbstractCommand<AdminClient> {

	private String url;
	
	
	public ConnectToGovernanceCommand(AdminClient client) throws ESBException {
		super(client);
		this.setName("ConnectToGovernance");
		this.setDescription("Connect to governance");
		this.setShortcut("cog");
	}
	
	@Override
	public void execute() {
		try {
			System.out.println("contact node: " + this.getClient().getAddress() + " and Connect it to governance: " + this.url);
			this.getClient().connectToGovernance(this.url);
			System.out.println("Apres Connect to governance: " + this.url);
			setResult("Connect to governance: " + this.url);
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		System.out.println("this.url = " + this.url);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "cog <url> \t\t\t\t\t\t{Connect to Governance}";
	}
	
}
