package com.ebmwebsourcing.easyesb.cli.impl.command;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClient;

public class ESBScriptCommand extends AbstractScriptCommand<UserManagementClient> {


	public ESBScriptCommand(UserManagementClient client, AbstractCommandManager cm) throws ESBException {
		super(client, cm);
	}

	public String executeAction(Element command) {
		String res = null;
		/** IMPORT SERVICE **/
		if("Bind".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			String wsdl = command.getChildText("Wsdl", Command.NAMESPACE_JDOM).trim();
			List<String> args = new ArrayList<String>();
			args.add(url);
			args.add(wsdl);

			BindCommand impl = (BindCommand) cm.findCommand("b");
			impl.process(args);

			res = "Bind result: " + impl.getResult();


		} else if("Expose".equals(command.getName())) {

			String serviceLocalPart = command.getChild("ServiceName", Command.NAMESPACE_JDOM).getTextTrim();
			String serviceNamespace = command.getChild("ServiceNamespace", Command.NAMESPACE_JDOM).getTextTrim();
			String endpoint = command.getChildTextTrim("EndpointName", Command.NAMESPACE_JDOM);

			List<String> args = new ArrayList<String>();
			args.add(serviceNamespace);
			args.add(serviceLocalPart);
			args.add(endpoint);


			ExposeCommand expose = (ExposeCommand) cm.findCommand("e");
			expose.process(args);
			res = "Expose result : "+expose.getResult();


		} else if("Deploy".equals(command.getName())){

			String main = command.getChild("MainResource", Command.NAMESPACE_JDOM).getTextTrim();
			List resourcesElement = command.getChildren("Resource", Command.NAMESPACE_JDOM);
			List<String> resources = new ArrayList<String>();
			resources.add(main);
			for(int i=0 ; i<resourcesElement.size() ; i++){
				resources.add(((Element)resourcesElement.get(i)).getTextTrim());
			}
			DeployCommand deploy = (DeployCommand) cm.findCommand("d");
			deploy.process(resources);

			res = "Deploy : "+deploy.getResult();
		} else if("Proxify".equals(command.getName())){

			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			String wsdl = command.getChildText("Wsdl", Command.NAMESPACE_JDOM).trim();

			List<String> args = new ArrayList<String>();
			args.add(url);
			args.add(wsdl);

			ProxifyCommand proxy = (ProxifyCommand) cm.findCommand("pr");
			proxy.process(args);

			res = "Proxify : "+proxy.getResult();

		} else if("AddNeighbourNode".equals(command.getName())){
			String url = command.getChildText("NeighbourAdminAddress", Command.NAMESPACE_JDOM);
			List<String> args = new ArrayList<String>();
			args.add(url);
			AddNeighbourNodeCommand add = (AddNeighbourNodeCommand) cm.findCommand("a");
			add.process(args);

			res = "AddNeighbourNode : "+add.getResult();
		} else if("SendSoapRequest".equals(command.getName())){

			String request = new XMLOutputter(Format.getPrettyFormat()).outputString(command.getChild("Request", Command.NAMESPACE_JDOM).getChild("Envelope", Namespace.getNamespace("http://schemas.xmlsoap.org/soap/envelope/")));
			String soapAction = command.getChildText("SoapAction", Command.NAMESPACE_JDOM).trim();

			List<String> args = new ArrayList<String>();
			args.add(request);
			args.add(soapAction);

			SendSoapRequestCommand proxy = (SendSoapRequestCommand) cm.findCommand("ss");
			proxy.process(args);

			res = "Send Soap Request. Receive response : \n"+proxy.getResult();

		} else if("ConnectToGovernance".equals(command.getName())){
			String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
			List<String> args = new ArrayList<String>();
			args.add(url);

			ConnectToGovernanceCommand impl = (ConnectToGovernanceCommand) cm.findCommand("cog");
			impl.process(args);

			res = "Connect To governance: " + impl.getResult();
		}
		return res;
	}

}
