/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogManager;

public abstract class AbstractClientLauncher {
    private String banner = null;
    private static final String LOGGER_FILE = "/logger/easyesb-logging.properties";
    private AbstractCommandManager console = null;

    public AbstractClientLauncher(AbstractCommandManager cm) throws ESBException {
        this.console = cm;
    }

    public AbstractCommandManager getConsole() {
        return this.console;
    }

    public void setConsole(AbstractCommandManager console) {
        this.console = console;
    }

    public String getBanner() {
        if (this.banner == null) {
            this.banner = " -----------------------------------------------------------\n|                                                           |\n|                          " + this.getDistributionName() + "                          |\n" + "|             EBM Research Enterprise Service Bus           |\n" + "|               http://research.petalslink.org              |\n" + "|                                                           |\n" + " -----------------------------------------------------------\n";
        }
        return this.banner;
    }

    protected void showBanner() {
        System.out.println();
        System.out.println(this.getBanner());
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        for (String arg : args) {
            command.add(arg);
        }
        try {
            System.out.println(this.getDistributionName() + " is starting...");
            System.out.println(this.getDistributionName() + " prompt. Tape 'h' for help.");
            this.commandLineMode(command);
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        this.console.printUsage();
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(List<String> commands) throws Exception {
        if (commands.size() == 0) {
            this.console.read();
        } else {
            List<String> command = this.console.detectCommand(commands);
            for (String com : command) {
                this.console.processCommandLine(com);
            }
        }
    }

    public abstract String getDistributionName();

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/easyesb-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : AbstractClientLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

