/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommand<C>
implements Command {
    private String name;
    private List<String> attributes;
    protected C client = null;
    private String result;
    protected int resultCode;
    public static final int SHUTDOWN_CODE = 0;
    public static final int ERROR_CODE = -1;
    public static final int OK_CODE = 1;
    public static final int INVALID_ARGS = -2;
    public static final int NO_CONNECTION = -3;
    private String shortcut;
    private String description;

    public AbstractCommand(C client) {
        this.client = client;
        this.attributes = new ArrayList<String>();
    }

    @Override
    public int process(List<String> args) {
        int result = 1;
        result = !this.validateArgs(args) ? -2 : this.doProcess(args);
        return result;
    }

    protected abstract int doProcess(List<String> var1);

    protected abstract boolean validateArgs(List<String> var1);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setAttributes(List<String> attrs) {
        this.attributes.clear();
        this.attributes = attrs;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    public C getClient() throws ManagementException {
        if (this.client == null) {
            throw new ManagementException("client cannot be null!!");
        }
        return this.client;
    }

    @Override
    public void setResult(String res) {
        this.result = res;
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public String getShortcut() {
        return this.shortcut;
    }

    @Override
    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

