package com.ebmwebsourcing.easyesb.sdk;

import java.io.File;

import org.apache.maven.plugin.MojoExecutionException;

import com.ebmwebsourcing.easyesb.mojo.CreationComponentArchetypeMojo;

public class TaskCreateComponent extends Task {

	private String packageName;

	private String componentName;

	public TaskCreateComponent(String packageName, String componentName) {
		this.packageName = packageName;
		this.componentName = componentName;
	}

	@Override
	public void execute() throws MojoExecutionException {
		CreationComponentArchetypeMojo mojo = new CreationComponentArchetypeMojo();
		mojo.setGeneratedSourceRoot(new File(".").toString());
		mojo.setTestsourceRoot(mojo.getGeneratedTestSourceRoot());

		if(this.packageName != null) {
			mojo.setPackageName(this.packageName);
		}
		if(this.componentName != null) {
			mojo.setComponentName(this.componentName);
		}
		
		System.out.println("Execute task create component with:\n\tpackage = " + mojo.getPackageName() + "\n\tcomponent name = " + mojo.getComponentName());
		mojo.execute();	

		String result = "" +
				"EasyESB Component Maven project has been created at " + mojo.getGeneratedSourceRoot() + "/" + mojo.getComponentName() + "\n" +
				"You can import your project in eclipse (using mvn eclipse:eclipse)\n" +
				"or compile your project (using mvn clean install)\n" +
				"or generate the new distribution (using mvn install '-Pdistrib') in project directory\n";

		this.setResult(result);
	}
}
